/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.parsers;

import java.util.regex.Matcher;
import pl.asie.charset.module.tablet.TabletUtil;
import pl.asie.charset.module.tablet.format.parsers.MarkdownParser;

public class GitHubMarkdownParser
extends MarkdownParser {
    private final String prefix;
    private final String name;

    public GitHubMarkdownParser(String host, String name) {
        this.prefix = "https://github.com/" + host + "/wiki";
        this.name = name;
    }

    @Override
    public String parse(String text) {
        if (this.name.equals("Home")) {
            text = "[-> Sidebar](_Sidebar)\n\n" + text;
        } else if (this.name.equals("_Sidebar")) {
            text = "[<- Home](Home)\n\n" + text;
        }
        return super.parse(text);
    }

    @Override
    protected String urlHandler(Matcher m) {
        String url = m.group(2);
        if (url.startsWith(this.prefix)) {
            return "\\\\url{" + TabletUtil.encode(url.substring(this.prefix.length())) + "}{" + m.group(1) + "}";
        }
        if (!url.contains("/")) {
            return "\\\\url{/" + TabletUtil.encode(url) + "}{" + m.group(1) + "}";
        }
        return "\\\\urlmissing{" + m.group(1) + "}";
    }
}

