/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.parsers;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.module.tablet.format.parsers.ParserBase;

public class MarkdownParser
extends ParserBase {
    public MarkdownParser() {
        Pattern.compile("<!--(.+)-->");
        this.replacers.add(Pair.of((Object)Pattern.compile("\\[([^]]*)]\\(([^)]+)\\)", 32), this::urlHandler));
        MarkdownParser.replace("<!--(.+)-->", 40, "");
    }

    protected String urlHandler(Matcher m) {
        return "\\\\urlmissing{" + m.group(1) + "}";
    }

    public String parse(String text) {
        String[] textLines = text.split("\n");
        StringBuilder builder = new StringBuilder();
        int headerCount = 0;
        for (int i = 0; i < textLines.length; ++i) {
            String line = textLines[i];
            if ("---".equals(line) && ++headerCount == 2) {
                builder = new StringBuilder();
                continue;
            }
            while (line.startsWith("!") && line.contains(")")) {
                line = line.substring(line.indexOf(")") + 1).trim() + "\n";
            }
            if (line.matches("^-+$")) {
                builder.append("\n");
            }
            line = line.replaceAll("\\\\", "\\\\").replaceAll("\\*\\*([^\\*]+)\\*\\*", "\\\\b{$1}").replaceAll("__([^\\*]+)__", "\\\\i{$1}").replaceAll("^(\\s*)\\*(\\s)", "$1\\\\-$2").replaceAll("^(\\s*)\\+(\\s)", "$1\\\\-$2").replaceAll("^(\\s*)-(\\s)", "$1\\\\-$2").replaceAll("^\\s*#+\\s+([^#]+)\\s*#*", "\\\\header{$1}\n").replaceAll("<([^>]+)>", "");
            builder.append(line).append('\n');
        }
        String out = builder.toString().trim();
        for (Pair pair : this.replacers) {
            StringBuffer result = new StringBuffer();
            Matcher matcher = ((Pattern)pair.getLeft()).matcher(out);
            while (matcher.find()) {
                matcher.appendReplacement(result, (String)((Function)pair.getRight()).apply(matcher));
            }
            matcher.appendTail(result);
            out = result.toString();
        }
        return out;
    }
}

