/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.parsers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.lib.utils.ThreeState;
import pl.asie.charset.module.tablet.TabletUtil;
import pl.asie.charset.module.tablet.format.parsers.ParserBase;

public class WikiParser
extends ParserBase {
    private final Map<String, ThreeState> existsData = new HashMap<String, ThreeState>();
    private String text = null;
    private String displaytitle = null;
    private boolean isMcwRedirect = false;
    private boolean isError = false;

    private ThreeState urlExists(String url) {
        return this.existsData.getOrDefault(url.toLowerCase(Locale.ROOT), ThreeState.MAYBE);
    }

    private void initReplacers(Type type) {
        if (type == Type.DOKUWIKI) {
            this.replacers.add(WikiParser.replace("\\*\\*([^\\*]+)\\*\\*", 0, "\\\\b{$1}"));
            this.replacers.add(WikiParser.replace("//([^\\*]+)//", 0, "\\\\i{$1}"));
            this.replacers.add(WikiParser.replace("^\\\\\\\\$", 8, "\\\\nl"));
            this.replacers.add(WikiParser.replace("\\~\\~(NOTOC)\\~\\~", 0, ""));
        } else {
            this.replacers.add(WikiParser.replace("'''([^']+)'''", 0, "\\\\b{$1}"));
        }
        this.replacers.add(WikiParser.replace("''([^']+)''", 0, "\\\\i{$1}"));
        this.replacers.add(WikiParser.replace("======([^=]+)======", 0, "\\\\header{$1}\n\n"));
        this.replacers.add(WikiParser.replace("=====([^=]+)=====", 0, "\\\\header{$1}\n\n"));
        this.replacers.add(WikiParser.replace("====([^=]+)====", 0, "\\\\header{$1}\n\n"));
        this.replacers.add(WikiParser.replace("===([^=]+)===", 0, "\\\\header{$1}\n\n"));
        this.replacers.add(WikiParser.replace("===([^=]+)===", 0, "\\\\header{$1}\n\n"));
        this.replacers.add(WikiParser.replace("==([^=]+)==", 0, "\\\\header{$1}\n\n"));
        this.replacers.add(WikiParser.replace("=([^=]+)=", 0, "\\\\header{$1}\n\n"));
        this.replacers.add(WikiParser.replace("\\<s\\>", 0, "\\\\del{"));
        this.replacers.add(WikiParser.replace("\\<\\/s\\>", 0, "}"));
        this.replacers.add(WikiParser.replace("^\\*\\*\\*\\*\\*\\*", 8, "\\\\-{5}"));
        this.replacers.add(WikiParser.replace("^\\*\\*\\*\\*\\*", 8, "\\\\-{4}"));
        this.replacers.add(WikiParser.replace("^\\*\\*\\*\\*", 8, "\\\\-{3}"));
        this.replacers.add(WikiParser.replace("^\\*\\*\\*", 8, "\\\\-{2}"));
        this.replacers.add(WikiParser.replace("^\\*\\*", 8, "\\\\-{1}"));
        this.replacers.add(WikiParser.replace("^\\s*\\*", 8, "\\\\-"));
        this.replacers.add(WikiParser.replace("^\\s*\\#", 8, "\\\\-"));
        this.replacers.add(Pair.of((Object)Pattern.compile("\\[\\[File:([^|.]+\\.[a-z]+)\\|([^|]+)\\|([^|]+)]]", 0), m -> {
            if (m.group(2).equals("thumb")) {
                return "\\\\i{Image: " + m.group(3) + "}";
            }
            return "\\\\i{Image: " + m.group(2) + "}";
        }));
        this.replacers.add(Pair.of((Object)Pattern.compile("\\[\\[Image:([^|.]+\\.[a-z]+)\\|([^|]+)\\|([^|]+)\\|([^|]+)]]", 0), m -> "\\\\i{Image: " + m.group(4) + "}"));
        this.replacers.add(Pair.of((Object)Pattern.compile("\\[\\[([^|\\]]+?)]]", 0), m -> {
            try {
                String url = m.group(1);
                if (url.startsWith("Category:") || url.startsWith("Template:")) {
                    return "";
                }
                if (this.urlExists(url) != ThreeState.NO) {
                    return "\\\\url{/" + TabletUtil.encode(url) + "}{" + m.group(1) + "}";
                }
                return "\\\\urlmissing{" + m.group(1) + "}";
            }
            catch (Exception e) {
                return "???";
            }
        }));
        this.replacers.add(Pair.of((Object)Pattern.compile("\\[\\[([^|\\]]+?)\\|([^|\\]]+?)]]", 0), m -> {
            try {
                String url = m.group(1);
                if (url.startsWith("Category:") || url.startsWith("Template:")) {
                    return "";
                }
                if (this.urlExists(url) != ThreeState.NO) {
                    return "\\\\url{/" + TabletUtil.encode(url) + "}{" + m.group(2) + "}";
                }
                return "\\\\urlmissing{" + m.group(2) + "}";
            }
            catch (Exception e) {
                return "???";
            }
        }));
        this.replacers.add(WikiParser.replace("\\<(.+?)\\>", 0, ""));
    }

    public WikiParser(String string, Type type) {
        this.initReplacers(type);
        if (type == Type.MEDIAWIKI) {
            JsonObject object = new JsonParser().parse(string).getAsJsonObject();
            if (object.has("parse")) {
                JsonObject wikiText;
                JsonObject cat;
                JsonArray array;
                if ((object = object.getAsJsonObject("parse")).has("iwlinks")) {
                    array = object.getAsJsonArray("iwlinks");
                    for (JsonElement element : array) {
                        String prefix;
                        cat = (JsonObject)element;
                        if (!cat.has("prefix") || !(prefix = cat.get("prefix").getAsString()).equals("mcw")) continue;
                        this.isMcwRedirect = true;
                    }
                }
                if (object.has("links")) {
                    array = object.getAsJsonArray("links");
                    for (JsonElement element : array) {
                        cat = (JsonObject)element;
                        if (!cat.has("*")) continue;
                        this.existsData.put(cat.get("*").getAsString().toLowerCase(Locale.ROOT), cat.has("exists") ? ThreeState.YES : ThreeState.NO);
                    }
                }
                if (object.has("wikitext") && (wikiText = object.getAsJsonObject("wikitext")).has("*")) {
                    this.text = wikiText.get("*").getAsString();
                }
                if (object.has("displaytitle")) {
                    this.displaytitle = object.get("displaytitle").getAsString();
                } else if (object.has("title")) {
                    this.displaytitle = object.get("title").getAsString();
                }
            } else if (object.has("error")) {
                this.isError = true;
                this.displaytitle = "Error";
                this.text = object.getAsJsonObject("error").get("info").getAsString();
            }
        } else {
            this.text = string;
        }
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean shouldRetain() {
        return !this.isMcwRedirect;
    }

    public String getText() {
        if (this.text == null) {
            return null;
        }
        String out = this.text;
        if (this.displaytitle != null) {
            out = "\\title{" + this.displaytitle + "}\n\n" + out;
        }
        for (Pair pair : this.replacers) {
            StringBuffer result = new StringBuffer();
            Matcher matcher = ((Pattern)pair.getLeft()).matcher(out);
            while (matcher.find()) {
                matcher.appendReplacement(result, (String)((Function)pair.getRight()).apply(matcher));
            }
            matcher.appendTail(result);
            out = result.toString();
        }
        int count = 0;
        int cutStart = 0;
        int cutEnd = 0;
        StringBuilder newOut = new StringBuilder();
        for (int i = 0; i < out.length() - 1; ++i) {
            if (out.codePointAt(i) == 123 && (out.codePointAt(i + 1) == 123 || out.codePointAt(i + 1) == 124)) {
                if (++count != 1) continue;
                cutStart = i;
                newOut.append(out.substring(cutEnd, cutStart));
                continue;
            }
            if (out.codePointAt(i) != 125 && out.codePointAt(i) != 124 || out.codePointAt(i + 1) != 125 || count <= 0 || --count != 0) continue;
            cutEnd = i + 2;
            if (i >= out.length() - 2 || out.codePointAt(i + 2) != 125) continue;
            ++cutEnd;
        }
        newOut.append(out.substring(cutEnd, out.length()));
        return newOut.toString().trim();
    }

    public static enum Type {
        MEDIAWIKI,
        DOKUWIKI;

    }
}

