/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.routers;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import pl.asie.charset.module.tablet.TabletUtil;
import pl.asie.charset.module.tablet.format.api.IRouter;
import pl.asie.charset.module.tablet.format.parsers.MarkdownParser;

public class RouterCoFH
implements IRouter {
    private final String host = "https://raw.githubusercontent.com/CoFH/cofh.github.io/master";

    @Override
    @Nullable
    public String get(URI path) {
        String err = "";
        try {
            HttpGet request;
            String pathCleaned = path.getPath();
            if (pathCleaned.endsWith("/")) {
                pathCleaned = pathCleaned.substring(0, pathCleaned.length() - 1);
            }
            if (pathCleaned.endsWith("/index")) {
                pathCleaned = pathCleaned.substring(0, pathCleaned.length() - 6);
            }
            URI uri = new URI("https://raw.githubusercontent.com/CoFH/cofh.github.io/master" + pathCleaned + "/index.md");
            HttpClient client = TabletUtil.createHttpClient();
            HttpResponse response = client.execute((HttpUriRequest)(request = new HttpGet(uri)));
            if (response.getStatusLine().getStatusCode() == 200) {
                MarkdownParser parser = new MarkdownParser();
                return parser.parse(new String(ByteStreams.toByteArray((InputStream)response.getEntity().getContent()), Charsets.UTF_8));
            }
            err = err + "ERROR: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase() + "\n\n";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return err.trim();
    }

    @Override
    public boolean matches(URI path) {
        return "wiki".equals(path.getScheme()) && "cofh".equals(path.getHost());
    }
}

