/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.routers;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import pl.asie.charset.module.tablet.TabletUtil;
import pl.asie.charset.module.tablet.format.api.IRouterSearchable;
import pl.asie.charset.module.tablet.format.parsers.WikiParser;

public class RouterDokuWiki
implements IRouterSearchable {
    private static final Pattern PATTERN = Pattern.compile("<a href=\"[^\"]+\" class=\"wikilink1\" title=\"([:_a-z]+)\">([^<]+)</a>");
    private final String host;
    private final String name;
    private final String friendlyName;

    public RouterDokuWiki(String name, String friendlyName, String host) {
        this.name = name;
        this.friendlyName = friendlyName;
        this.host = host;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public String get(URI path) {
        String err = "";
        try {
            URI uri = new URI("http://" + this.host + "?id=" + TabletUtil.encode(path.getPath().substring(1).replace('/', ':')) + "&do=export_raw");
            HttpClient client = TabletUtil.createHttpClient();
            HttpGet request = new HttpGet(uri);
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                WikiParser mediaWikiData = new WikiParser(new String(ByteStreams.toByteArray((InputStream)response.getEntity().getContent()), Charsets.UTF_8), WikiParser.Type.DOKUWIKI);
                if (!mediaWikiData.shouldRetain()) return err.trim();
                if (!mediaWikiData.isError()) return mediaWikiData.getText();
                err = err + mediaWikiData.getText() + "\n\n";
                return err.trim();
            } else {
                err = err + "ERROR: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase() + "\n\n";
            }
            return err.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean matches(URI path) {
        return "wiki".equals(path.getScheme()) && this.name.equals(path.getHost());
    }

    @Override
    public void find(Collection<IRouterSearchable.SearchResult> results, String query) {
        try {
            String data;
            int i;
            URI uri = new URI("http://" + this.host + "?do=search&id=" + TabletUtil.encode(query));
            HttpClient client = TabletUtil.createHttpClient();
            HttpGet request = new HttpGet(uri);
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200 && (i = (data = new String(ByteStreams.toByteArray((InputStream)response.getEntity().getContent()), Charsets.UTF_8)).indexOf("search_results")) >= 0) {
                Matcher m = PATTERN.matcher(data.substring(i));
                while (m.find()) {
                    IRouterSearchable.SearchResult result = new IRouterSearchable.SearchResult(m.group(2), this.friendlyName, new URI("wiki://" + this.name + "/" + m.group(1).replace(':', '/')));
                    results.add(result);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

