/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.routers;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import pl.asie.charset.module.tablet.TabletUtil;
import pl.asie.charset.module.tablet.format.api.IRouter;
import pl.asie.charset.module.tablet.format.parsers.GitHubMarkdownParser;
import pl.asie.charset.module.tablet.format.parsers.MarkdownParser;

public class RouterGitHub
implements IRouter {
    private final String host;
    private final String hostIngame;

    public RouterGitHub(String host, String hostIngame) {
        this.host = host;
        this.hostIngame = hostIngame;
    }

    @Override
    @Nullable
    public String get(URI path) {
        String err = "";
        try {
            HttpGet request;
            String pathCleaned = path.getPath();
            if (pathCleaned.length() <= 1) {
                pathCleaned = "/Home";
            }
            String hostPath = "https://raw.githubusercontent.com/wiki/" + this.host;
            URI uri = new URI(hostPath + pathCleaned + ".md");
            HttpClient client = TabletUtil.createHttpClient();
            HttpResponse response = client.execute((HttpUriRequest)(request = new HttpGet(uri)));
            if (response.getStatusLine().getStatusCode() == 200) {
                GitHubMarkdownParser parser = new GitHubMarkdownParser(this.host, pathCleaned.substring(1));
                return ((MarkdownParser)parser).parse(new String(ByteStreams.toByteArray((InputStream)response.getEntity().getContent()), Charsets.UTF_8));
            }
            err = err + "ERROR: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase() + "\n\n";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return err.trim();
    }

    @Override
    public boolean matches(URI path) {
        return "wiki".equals(path.getScheme()) && this.hostIngame.equals(path.getHost());
    }
}

