/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.routers;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import pl.asie.charset.module.tablet.TabletUtil;
import pl.asie.charset.module.tablet.format.api.IRouterSearchable;
import pl.asie.charset.module.tablet.format.parsers.WikiParser;

public class RouterMediaWiki
implements IRouterSearchable {
    private final String[] hosts;
    private final String name;
    private final String friendlyName;

    public RouterMediaWiki(String name, String friendlyName, String ... hosts) {
        this.name = name;
        this.friendlyName = friendlyName;
        this.hosts = hosts;
    }

    @Override
    @Nullable
    public String get(URI path) {
        String err = "";
        String[] hostsChecks = this.hosts;
        if ("gamepedia".equals(this.name) && path.toString().endsWith("%20%28Vanilla%29")) {
            try {
                path = new URI(path.toString().replaceAll("%20%28Vanilla%29", ""));
                hostsChecks = new String[]{"minecraft.gamepedia.com"};
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String host : hostsChecks) {
            try {
                URI uri = new URI("http://" + host + "/api.php?action=parse&prop=wikitext%7clanglinks%7ccategories%7clinks%7cdisplaytitle%7ciwlinks%7cproperties&format=json&page=" + TabletUtil.encode(path.getPath().substring(1)));
                HttpClient client = TabletUtil.createHttpClient();
                HttpGet request = new HttpGet(uri);
                HttpResponse response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    WikiParser mediaWikiData = new WikiParser(new String(ByteStreams.toByteArray((InputStream)response.getEntity().getContent()), Charsets.UTF_8), WikiParser.Type.MEDIAWIKI);
                    if (!mediaWikiData.shouldRetain()) continue;
                    if (mediaWikiData.isError()) {
                        err = err + mediaWikiData.getText() + "\n\n";
                        continue;
                    }
                    return mediaWikiData.getText();
                }
                err = err + "ERROR: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase() + "\n\n";
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return err.trim();
    }

    @Override
    public boolean matches(URI path) {
        return "wiki".equals(path.getScheme()) && this.name.equals(path.getHost());
    }

    @Override
    public void find(Collection<IRouterSearchable.SearchResult> results, String query) {
        for (String host : this.hosts) {
            try {
                String data;
                JsonArray array;
                URI uri = new URI("https://" + host + "/api.php?action=opensearch&search=" + TabletUtil.encode(query) + "&limit=50&format=json");
                HttpClient client = TabletUtil.createHttpClient();
                HttpGet request = new HttpGet(uri);
                HttpResponse response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() != 200 || (array = new JsonParser().parse(data = new String(ByteStreams.toByteArray((InputStream)response.getEntity().getContent()), Charsets.UTF_8)).getAsJsonArray()).size() != 4) continue;
                JsonArray names = array.get(1).getAsJsonArray();
                JsonArray urls = array.get(3).getAsJsonArray();
                for (int i = 0; i < Math.min(names.size(), urls.size()); ++i) {
                    String name = names.get(i).getAsString();
                    URI realUri = new URI(urls.get(i).getAsString());
                    if (name.contains("/")) continue;
                    IRouterSearchable.SearchResult result = new IRouterSearchable.SearchResult(name, this.friendlyName, new URI("wiki://" + this.name + realUri.getPath()));
                    results.add(result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

