/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.routers;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import pl.asie.charset.module.tablet.format.api.IRouterSearchable;

public class RouterModDocumentation
implements IRouterSearchable {
    private final String modid;
    private final String friendlyName;

    public RouterModDocumentation(String modid, String friendlyName) {
        this.modid = modid;
        this.friendlyName = friendlyName;
    }

    @Override
    @Nullable
    public String get(URI path) {
        ResourceLocation loc = "mod".equals(path.getScheme()) ? new ResourceLocation(this.modid, "doc" + path.getPath() + ".txt") : new ResourceLocation(this.modid, "doc/" + path.getScheme() + path.getPath() + ".txt");
        try {
            byte[] data = ByteStreams.toByteArray((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(loc).func_110527_b());
            return new String(data, Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            return "\\title{Not found!}\n\nThe documentation you are looking for cannot be found.";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean matches(URI path) {
        if ("item".equals(path.getScheme()) || "mod".equals(path.getScheme()) || "entity".equals(path.getScheme())) {
            return this.modid.equals(path.getHost());
        }
        return false;
    }

    @Override
    public void find(Collection<IRouterSearchable.SearchResult> results, String query) {
        for (Item i : Item.field_150901_e) {
            if (!this.modid.equals(i.getRegistryName().func_110624_b())) continue;
            ResourceLocation loc = new ResourceLocation(this.modid, "doc/item/" + i.getRegistryName().func_110623_a() + ".txt");
            try {
                Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
                String name = I18n.func_74838_a((String)(i.func_77658_a() + ".name"));
                if (!query.toLowerCase().contains(name.toLowerCase())) continue;
                results.add(new IRouterSearchable.SearchResult(name, this.friendlyName, new URI("item://" + this.modid + "/" + i.getRegistryName().func_110623_a())));
            }
            catch (Exception exception) {}
        }
    }
}

