/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.routers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import pl.asie.charset.module.tablet.TabletUtil;
import pl.asie.charset.module.tablet.format.api.IRouter;
import pl.asie.charset.module.tablet.format.api.IRouterSearchable;
import pl.asie.charset.module.tablet.format.api.TabletAPI;

public class RouterSearch
implements IRouter {
    private final Cache<String, List<IRouterSearchable.SearchResult>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();

    @Override
    @Nullable
    public String get(URI path) {
        try {
            String query = TabletUtil.decode(path.getPath()).substring(1);
            ArrayList resultList = (ArrayList)this.cache.getIfPresent((Object)query.toLowerCase());
            if (resultList == null) {
                ArrayList resultListF = resultList = new ArrayList();
                TabletAPI.INSTANCE.getRouters().parallelStream().forEach(router -> {
                    if (router instanceof IRouterSearchable) {
                        ArrayList<IRouterSearchable.SearchResult> resultListInner = new ArrayList<IRouterSearchable.SearchResult>();
                        ((IRouterSearchable)router).find(resultListInner, query.toLowerCase(Locale.ROOT));
                        if (!resultListInner.isEmpty()) {
                            List list = resultListF;
                            synchronized (list) {
                                resultListF.addAll(resultListInner);
                            }
                        }
                    }
                });
                this.cache.put((Object)query.toLowerCase(Locale.ROOT), resultList);
            }
            StringBuilder search = new StringBuilder("\\title{" + query + "}\n\n");
            if (resultList.size() == 0) {
                search.append("No results.");
            } else {
                HashSet<IRouterSearchable.SearchResult> resultSet = new HashSet<IRouterSearchable.SearchResult>();
                for (IRouterSearchable.SearchResult result : resultList) {
                    if (!resultSet.add(result)) continue;
                    search.append("\\- \\url{" + result.uri.toString() + "}{" + result.text + "} (" + result.providerName + ")\n");
                }
                search.append("\n" + resultSet.size() + " result" + (resultSet.size() == 1 ? "" : "s") + ".");
            }
            return search.toString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public boolean matches(URI path) {
        return "about".equals(path.getScheme()) && "search".equals(path.getHost());
    }
}

