/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.format.words;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.module.tablet.format.api.Word;

public class WordImage
extends Word {
    public final ResourceLocation resource;
    public int width = 12;
    public int height = 12;
    private static final HashMap<ResourceLocation, Pair<Integer, Integer>> size_cache = new HashMap();

    public WordImage(ResourceLocation resource) {
        this.resource = resource;
        this.autosize();
    }

    public WordImage(ResourceLocation resource, int width, int height) {
        this(resource);
        this.width = width;
        this.height = height;
    }

    public void scale(double scale) {
        this.width = (int)((double)this.width * scale);
        this.height = (int)((double)this.height * scale);
    }

    private void autosize() {
        Pair<Integer, Integer> cached = size_cache.get(this.resource);
        if (cached != null) {
            this.width = (Integer)cached.getLeft();
            this.height = (Integer)cached.getRight();
            return;
        }
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        try {
            IResource iresource = resourceManager.func_110536_a(this.resource);
            BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            this.width = bufferedimage.getWidth();
            this.height = bufferedimage.getHeight();
            size_cache.put(this.resource, (Pair<Integer, Integer>)Pair.of((Object)this.width, (Object)this.height));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void fitToPage(int pageWidth, int pageHeight) {
        double h;
        double s = 1.0;
        if (this.width > pageWidth) {
            s = (double)pageWidth / (double)this.width;
        }
        if (this.height > pageHeight && (h = (double)pageHeight / (double)this.height) < s) {
            s = h;
        }
        this.scale(s);
    }
}

