/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.modcompat.guideapi;

import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.page.PageText;
import amerifrance.guideapi.page.PageTextImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.module.tablet.TabletUtil;
import pl.asie.charset.module.tablet.format.api.IRouterSearchable;

public class RouterGuideAPI
implements IRouterSearchable {
    private final ResourceLocation location;
    private final Book book;

    public RouterGuideAPI(ResourceLocation location, Book book) {
        this.location = location;
        this.book = book;
    }

    public CategoryAbstract getCategory(String name) {
        name = name.toLowerCase(Locale.ROOT);
        for (CategoryAbstract category : this.book.getCategoryList()) {
            if (!category.name.toLowerCase(Locale.ROOT).equals(name)) continue;
            return category;
        }
        return null;
    }

    private String getIndex() {
        StringBuilder builder = new StringBuilder("\\title{\\local{" + this.book.getDisplayName() + "}}\n");
        for (CategoryAbstract category : this.book.getCategoryList()) {
            builder.append("\n\\- \\url{/" + this.location.func_110623_a() + "/" + TabletUtil.encode(category.name.toLowerCase(Locale.ROOT)) + "}{" + category.getLocalizedName() + "}");
        }
        return builder.toString();
    }

    private String getCategory(CategoryAbstract category) {
        StringBuilder builder = new StringBuilder("\\title{" + category.getLocalizedName() + "}\n");
        for (Map.Entry entry : category.entries.entrySet()) {
            builder.append("\n\\- \\url{/" + this.location.func_110623_a() + "/" + TabletUtil.encode(category.name.toLowerCase(Locale.ROOT)) + "/" + TabletUtil.encode(((EntryAbstract)entry.getValue()).name.toLowerCase(Locale.ROOT)) + "}{" + ((EntryAbstract)entry.getValue()).getLocalizedName() + "}");
        }
        builder.append("\n\n\\url{/" + this.location.func_110623_a() + "/index}{Back}");
        return builder.toString();
    }

    private String getEntry(CategoryAbstract category, EntryAbstract entry) {
        StringBuilder builder = new StringBuilder("\\title{" + entry.getLocalizedName() + "}\n\n");
        for (IPage page : entry.pageList) {
            if (page instanceof PageTextImage) {
                builder.append(((PageTextImage)page).draw.replaceAll("\\\\n", "\n")).append("\n\n");
                continue;
            }
            if (!(page instanceof PageText)) continue;
            builder.append(((PageText)page).draw.replaceAll("\\\\n", "\n")).append("\n\n");
        }
        builder.append("\\url{/" + this.location.func_110623_a() + "/" + TabletUtil.encode(category.name.toLowerCase(Locale.ROOT)) + "}{Back}");
        return builder.toString().trim();
    }

    @Override
    @Nullable
    public String get(URI path) {
        String[] splits;
        String cutPath = TabletUtil.decode(path.getPath().substring(this.location.func_110623_a().length() + 1));
        if (cutPath.length() <= 1 || "/index".equals(cutPath)) {
            return this.getIndex();
        }
        if (cutPath.startsWith("/")) {
            cutPath = cutPath.substring(1);
        }
        if (cutPath.endsWith("/")) {
            cutPath = cutPath.substring(cutPath.length() - 1);
        }
        if (cutPath.endsWith("/index")) {
            cutPath = cutPath.substring(cutPath.length() - 6);
        }
        if ((splits = cutPath.split("/")).length == 1) {
            return this.getCategory(this.getCategory(splits[0]));
        }
        if (splits.length == 2) {
            CategoryAbstract category = this.getCategory(splits[0]);
            for (Map.Entry entry : category.entries.entrySet()) {
                if (!splits[1].equals(((EntryAbstract)entry.getValue()).name.toLowerCase(Locale.ROOT))) continue;
                return this.getEntry(category, (EntryAbstract)entry.getValue());
            }
        }
        return null;
    }

    @Override
    public boolean matches(URI path) {
        return "guideapi".equals(path.getScheme()) && this.location.func_110624_b().equals(path.getHost()) && path.getPath().startsWith("/" + this.location.func_110623_a());
    }

    @Override
    public void find(Collection<IRouterSearchable.SearchResult> results, String query) {
        for (CategoryAbstract category : this.book.getCategoryList()) {
            for (Map.Entry entry : category.entries.entrySet()) {
                if (!query.toLowerCase().contains(((EntryAbstract)entry.getValue()).getLocalizedName().toLowerCase())) continue;
                try {
                    results.add(new IRouterSearchable.SearchResult(((EntryAbstract)entry.getValue()).getLocalizedName(), this.book.getLocalizedDisplayName(), new URI("guideapi://" + this.location.func_110624_b() + "/" + this.location.func_110623_a() + "/" + TabletUtil.encode(category.name.toLowerCase(Locale.ROOT)) + "/" + TabletUtil.encode(((EntryAbstract)entry.getValue()).name.toLowerCase(Locale.ROOT)))));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

