/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.modcompat.igw;

import com.google.common.base.Charsets;
import com.google.common.io.MoreFiles;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.utils.UtilProxyCommon;
import pl.asie.charset.module.tablet.format.api.IRouterSearchable;

public class RouterIGW
implements IRouterSearchable {
    private static final Pattern pattern = Pattern.compile("\\[([a-z]+)\\{([^}\\]]*)}]");
    private final String modid;
    private final String friendlyName;
    private final Path path;

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public RouterIGW(String modid, Path path) {
        this.modid = modid;
        this.path = path;
        String fn = modid;
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (!container.getModId().equals(modid)) continue;
            fn = container.getName();
            break;
        }
        this.friendlyName = fn + " In-Game Wiki";
    }

    public String getItem(String name) {
        ResourceLocation loc = new ResourceLocation(this.modid, name);
        Path p = this.getDocIfExists(loc);
        if (p != null) {
            try {
                String unl;
                Item i = Item.func_111206_d((String)loc.toString());
                byte[] data = MoreFiles.asByteSource((Path)p, (OpenOption[])new OpenOption[0]).read();
                String s = new String(data, Charsets.UTF_8);
                s = s.replaceAll("[0-9+]\\. ", "\n\\- ");
                StringBuffer result = new StringBuffer();
                Matcher matcher = pattern.matcher(s);
                while (matcher.find()) {
                    String cmd = matcher.group(1);
                    String[] args = matcher.group(2).split(", ");
                    if ("link".equals(cmd) && args.length <= 1) {
                        if (args.length <= 0 || args[0].length() == 0) {
                            matcher.appendReplacement(result, "}");
                            continue;
                        }
                        ResourceLocation loc2 = new ResourceLocation(args[0]);
                        String url = "igw://" + loc2.func_110624_b() + "/item/" + loc2.func_110623_a().replaceAll("^block/", "").replaceAll("^item/", "");
                        matcher.appendReplacement(result, "\\\\url{" + url + "}{");
                        continue;
                    }
                    if ("prefix".equals(cmd) && args.length <= 1) {
                        if (args.length <= 0 || args[0].length() == 0) {
                            matcher.appendReplacement(result, "}\n");
                            continue;
                        }
                        String cmdn = "header";
                        if ("l".equals(args[0])) {
                            cmdn = "b";
                        } else if ("m".equals(args[0])) {
                            cmdn = "del";
                        } else if ("n".equals(args[0])) {
                            cmdn = "u";
                        } else if ("o".equals(args[0])) {
                            cmdn = "i";
                        }
                        matcher.appendReplacement(result, "\\\\" + cmdn + "{");
                        continue;
                    }
                    if ("image".equals(cmd) && args.length == 4) {
                        matcher.appendReplacement(result, "\\\\img{" + args[3] + "}{" + args[2] + "}");
                        continue;
                    }
                    ModCharset.logger.warn("Unsupported IGW command " + cmd + "(" + args.length + ")!");
                    matcher.appendReplacement(result, "");
                }
                matcher.appendTail(result);
                String out = result.toString().trim();
                if (i != null && I18n.func_94522_b((String)(unl = i.func_77658_a() + ".name"))) {
                    out = "\\title{" + I18n.func_74838_a((String)unl) + "}\n\n" + out;
                }
                return out;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public String getIndex() {
        StringBuilder builder = new StringBuilder("\\title{" + this.friendlyName + "}\n");
        for (Item i : Item.field_150901_e) {
            Path p;
            if (!this.modid.equals(i.getRegistryName().func_110624_b()) || (p = this.getDocIfExists(i.getRegistryName())) == null) continue;
            String nname = I18n.func_74838_a((String)(i.func_77658_a() + ".name"));
            builder.append("\n\\- \\url{/item/" + i.getRegistryName().func_110623_a() + "}{" + nname + "}");
        }
        return builder.toString();
    }

    @Override
    @Nullable
    public String get(URI path) {
        if ("item".equals(path.getScheme())) {
            return this.getItem(path.getPath().substring(1));
        }
        if ("igw".equals(path.getScheme())) {
            if (path.getPath().startsWith("/item/")) {
                return this.getItem(path.getPath().substring(6));
            }
            if (path.getPath().length() <= 1 || path.getPath().startsWith("/index")) {
                return this.getIndex();
            }
        }
        return null;
    }

    @Nullable
    private Path getDocIfExists(ResourceLocation loc, String langCode, String b) {
        Path nPath = this.path.resolve("./" + langCode + "/" + b + "/" + loc.func_110623_a() + ".txt");
        if (Files.exists(nPath, new LinkOption[0])) {
            return nPath;
        }
        return null;
    }

    @Nullable
    public Path getDocIfExists(ResourceLocation loc) {
        String l = UtilProxyCommon.proxy.getLanguageCode();
        Path path = this.getDocIfExists(loc, l, "block");
        if (path == null) {
            path = this.getDocIfExists(loc, l, "item");
        }
        if (path == null && !"en_us".equals(l) && (path = this.getDocIfExists(loc, "en_us", "block")) == null) {
            path = this.getDocIfExists(loc, "en_us", "item");
        }
        return path;
    }

    @Override
    public boolean matches(URI path) {
        if ("igw".equals(path.getScheme())) {
            return path.getHost().equals(this.modid);
        }
        if ("item".equals(path.getScheme()) && !"minecraft".equals(this.modid)) {
            return path.getHost().equals(this.modid);
        }
        return false;
    }

    @Override
    public void find(Collection<IRouterSearchable.SearchResult> results, String query) {
        for (Item i : Item.field_150901_e) {
            Path p;
            if (!this.modid.equals(i.getRegistryName().func_110624_b()) || (p = this.getDocIfExists(i.getRegistryName())) == null) continue;
            try {
                String name = I18n.func_74838_a((String)(i.func_77658_a() + ".name"));
                if (!query.toLowerCase().contains(name.toLowerCase())) continue;
                results.add(new IRouterSearchable.SearchResult(name, this.friendlyName, new URI("igw://" + this.modid + "/item/" + i.getRegistryName().func_110623_a())));
            }
            catch (Exception exception) {}
        }
    }
}

