/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.modcompat.mcjty;

import com.google.common.base.Charsets;
import com.google.common.collect.HashBasedTable;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.ModPathIterator;
import pl.asie.charset.module.tablet.format.api.TabletAPI;
import pl.asie.charset.module.tablet.modcompat.mcjty.RouterMcJty;

@CharsetModule(name="mcjtylib:tablet", profile=ModuleProfile.COMPAT, dependencies={"tablet"})
public class CharsetTabletCompatMcJty {
    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onPostInit(FMLPostInitializationEvent event) {
        HashBasedTable books = HashBasedTable.create();
        for (Pair pair : ModPathIterator.getValidPaths((String)"assets/%1/text/")) {
            Path p = (Path)pair.getRight();
            try {
                Iterator it = Files.walk(p, new FileVisitOption[0]).iterator();
                while (it.hasNext()) {
                    Path path = (Path)it.next();
                    String s = path.getFileName().toString();
                    if (!s.startsWith("manual") || !s.endsWith(".txt")) continue;
                    String name = s.substring(0, s.length() - 4);
                    String lang = "en_us";
                    if (name.lastIndexOf(45) >= 0) {
                        lang = name.substring(name.lastIndexOf(45) + 1);
                        name = name.substring(0, name.lastIndexOf(45));
                    }
                    books.put((Object)((String)pair.getLeft() + "_" + name), (Object)lang, (Object)path);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String name : books.rowKeySet()) {
            HashMap<String, String> texts = new HashMap<String, String>();
            String friendlyName = null;
            for (String lang : books.row((Object)name).keySet()) {
                try {
                    byte[] data = MoreFiles.asByteSource((Path)((Path)books.get((Object)name, (Object)lang)), (OpenOption[])new OpenOption[0]).read();
                    String text = new String(data, Charsets.UTF_8);
                    if (lang.equals("en_us")) {
                        String firstLine = text.split("\n", 2)[0];
                        friendlyName = firstLine.substring(firstLine.lastIndexOf(125) + 1);
                    }
                    texts.put(lang, text);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (friendlyName == null) continue;
            RouterMcJty routerMcJty = new RouterMcJty(name, friendlyName);
            for (String lang : texts.keySet()) {
                routerMcJty.add(lang, (String)texts.get(lang));
            }
            TabletAPI.INSTANCE.registerRouter(routerMcJty);
            TabletAPI.INSTANCE.addBook(friendlyName, "mcjty://" + name + "/");
        }
    }
}

