/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tablet.modcompat.mcjty;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import pl.asie.charset.lib.utils.UtilProxyCommon;
import pl.asie.charset.module.tablet.format.api.IRouter;

public class RouterMcJty
implements IRouter {
    private final String name;
    private final String friendlyName;
    private final Map<String, String> langToText = new HashMap<String, String>();

    public RouterMcJty(String name, String friendlyName) {
        this.name = name;
        this.friendlyName = friendlyName;
    }

    protected void add(String lang, String text) {
        String[] parsedText = text.split("\n");
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < parsedText.length; ++i) {
            String line = parsedText[i];
            line = line.replaceAll("^\\{b}(.+)$", "\\\\header{$1}\n").replaceAll("^\\{l:(.+)}(.+)$", "\\\\- $2").replaceAll("^\\{/}$", "").replaceAll("^\\s*\\{(.+)}$", "");
            out.append(line).append('\n');
        }
        this.langToText.put(lang, out.toString().trim());
    }

    @Override
    @Nullable
    public String get(URI path) {
        String text = this.langToText.get(UtilProxyCommon.proxy.getLanguageCode());
        if (text == null && (text = this.langToText.get("en_us")) == null) {
            text = "\\header{Error}\nNot found!";
        }
        return text;
    }

    @Override
    public boolean matches(URI path) {
        return "mcjty".equals(path.getScheme()) && this.name.equals(path.getAuthority());
    }
}

