/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyEnumSimple<T extends Enum<T>>
extends PropertyHelper<T> {
    List<T> allowedValues = new ArrayList<T>();
    HashMap<String, T> nameToValue = new HashMap();
    EnumMap<T, String> propertyNames;

    public PropertyEnumSimple(Class<T> valueClass) {
        this(valueClass, valueClass.getSimpleName().toLowerCase());
    }

    public PropertyEnumSimple(Class<T> valueClass, String name) {
        super(name, valueClass);
        this.allowedValues = Lists.newArrayList((Object[])valueClass.getEnumConstants());
        Collections.sort(this.allowedValues);
        this.propertyNames = new EnumMap(valueClass);
        for (Enum t : this.allowedValues) {
            String key = t.toString().toLowerCase();
            this.nameToValue.put(key, t);
            this.propertyNames.put(t, key);
        }
    }

    @Nonnull
    public Collection<T> func_177700_c() {
        return this.allowedValues;
    }

    @Nonnull
    public Optional<T> func_185929_b(@Nonnull String value) {
        return Optional.fromNullable(this.nameToValue.get(value));
    }

    @Nonnull
    public String getName(@Nonnull T value) {
        return this.propertyNames.get(value);
    }
}

