/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineRegistry;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.blocks.BlockTerraformer;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.EnchantRecipe;
import com.rwtema.extrautils2.crafting.jei.BlockPatternHandler;
import com.rwtema.extrautils2.crafting.jei.JEIIndexerTransfer;
import com.rwtema.extrautils2.crafting.jei.JEIMachine;
import com.rwtema.extrautils2.crafting.jei.JEIResonatorHandler;
import com.rwtema.extrautils2.crafting.jei.JEITerraformerHandler;
import com.rwtema.extrautils2.crafting.jei.JEIVanillaCraftingRecipeHandler;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.DynamicWindow;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.IWidgetCustomJEIIngredient;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrowNetworkBase;
import com.rwtema.extrautils2.gui.backend.WidgetSlotGhost;
import com.rwtema.extrautils2.items.ItemFakeCopy;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.items.ItemUnstableIngots;
import com.rwtema.extrautils2.items.itemmatching.IMatcherMaker;
import com.rwtema.extrautils2.machine.BlockMachine;
import com.rwtema.extrautils2.machine.ItemBlockMachine;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.structure.PatternRecipe;
import com.rwtema.extrautils2.tile.TileCrafter;
import com.rwtema.extrautils2.tile.TileResonator;
import com.rwtema.extrautils2.tile.TileTerraformer;
import com.rwtema.extrautils2.tile.TileTerraformerClimograph;
import com.rwtema.extrautils2.transfernodes.TileIndexer;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.LogHelper;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

@JEIPlugin
public class XUJEIPlugin
extends BlankModPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IRecipeRegistry recipeRegistry;
    public static IGuiHelper guiHelper;

    public XUJEIPlugin() {
        LogHelper.info("Extra Utilities 2 JEI Plugin - ACTIVATE!", new Object[0]);
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistry subtypeRegistry) {
        if (XU2Entries.machineEntry.isActive()) {
            subtypeRegistry.registerSubtypeInterpreter((Item)Validate.notNull((Object)Item.func_150898_a((Block)((Block)XU2Entries.machineEntry.value))), (ISubtypeRegistry.ISubtypeInterpreter)new MachineSubtypeInterpreter());
        }
        if (XU2Entries.unstableIngots.isActive()) {
            subtypeRegistry.registerSubtypeInterpreter((Item)XU2Entries.unstableIngots.value, (ISubtypeRegistry.ISubtypeInterpreter)new UnstableIIngotInterpreter());
        }
    }

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{BlockPatternHandler.category});
        registry.addRecipeHandlers(new IRecipeHandler[]{BlockPatternHandler.handler});
        registry.addRecipes(PatternRecipe.recipeList);
        if (XU2Entries.itemFakeCopy.isActive() && !ItemFakeCopy.showAllItems()) {
            jeiHelpers.getItemBlacklist().addItemToBlacklist(XU2Entries.itemFakeCopy.newStack(1, Short.MAX_VALUE));
        }
        if (XU2Entries.blockSpotlight.isActive()) {
            jeiHelpers.getItemBlacklist().addItemToBlacklist(XU2Entries.blockSpotlight.newStack(1, Short.MAX_VALUE));
        }
        if (XU2Entries.sunCrystal.isActive()) {
            registry.addDescription(XU2Entries.sunCrystal.newStack(1), new String[]{Lang.translate("Craft an empty Sun Crystal first, then throw the crystal on the ground in direct sunlight.")});
        }
        if (XU2Entries.blockEnderLilly.isActive()) {
            registry.addDescription(XU2Entries.blockEnderLilly.newStack(1), new String[]{Lang.translate("Found in dungeon chests.")});
        }
        if (XU2Entries.blockRedOrchid.isActive()) {
            registry.addDescription(XU2Entries.blockRedOrchid.newStack(1), new String[]{Lang.translate("Found in dungeon chests.")});
        }
        if (XU2Entries.itemIngredients.isActive()) {
            registry.addDescription(ItemIngredients.Type.EVIL_DROP.newStack(), new String[]{Lang.translate("Rare drop from wither skeletons")});
            registry.addDescription(ItemIngredients.Type.DEMON_INGOT.newStack(), new String[]{Lang.translate("extrautils2.text.demon_ingot_lore", "Legends tell of ancient creatures from before the dawn of humans, whose bodies were deformed by the heavens. They fled to a strange realm beneath the earth and built elaborate temples of worship to their new homeland. They infused the bones of their dead with dark energy and weaved constructs of living flame. But their most powerful creations were lava wells where they would throw special metals, hoping that their tribute would be answered with riches.")});
        }
        if (XU2Entries.cursedEarth.isActive()) {
            registry.addDescription(XU2Entries.cursedEarth.newStack(), new String[]{Lang.translate("Right click soil with a drop of evil.")});
        }
        if (XU2Entries.terraformer.isActive()) {
            JEITerraformerHandler terraformer = new JEITerraformerHandler();
            registry.addRecipeCategoryCraftingItem(TileTerraformer.getStack(BlockTerraformer.Type.CONTROLLER), new String[]{"extrautils2.terraformer"});
            registry.addRecipeCategories(new IRecipeCategory[]{terraformer});
            registry.addRecipeHandlers(new IRecipeHandler[]{terraformer});
            ArrayList<JEITerraformerHandler.Holder> list = new ArrayList<JEITerraformerHandler.Holder>();
            for (Map.Entry entry2 : TileTerraformerClimograph.inputTypes.entries()) {
                list.add(new JEITerraformerHandler.Holder((BlockTerraformer.Type)((Object)entry2.getKey()), (IMatcherMaker)((Pair)entry2.getValue()).getKey(), 40 * (Integer)((Pair)entry2.getValue()).getValue()));
            }
            registry.addRecipes(list);
        }
        if (XU2Entries.resonator.isActive()) {
            JEIResonatorHandler resonator = new JEIResonatorHandler();
            registry.addRecipeCategoryCraftingItem(XU2Entries.resonator.newStack(), new String[]{"extrautils2.resonator"});
            registry.addRecipeCategories(new IRecipeCategory[]{resonator});
            registry.addRecipeHandlers(new IRecipeHandler[]{resonator});
            registry.addRecipes(TileResonator.resonatorRecipes);
        }
        if (XU2Entries.machineEntry.isActive()) {
            JEIMachine.helper = registry.getIngredientRegistry().getIngredientHelper(ItemStack.class);
            JEIMachine.renderer = registry.getIngredientRegistry().getIngredientRenderer(ItemStack.class);
            registry.addRecipeHandlers(new IRecipeHandler[]{JEIMachine.Handler.INSTANCE});
            for (Machine machine : MachineRegistry.getMachineValues()) {
                JEIMachine handler = new JEIMachine(machine);
                registry.addRecipeCategoryCraftingItem(((BlockMachine)XU2Entries.machineEntry.value).createStack(machine), new String[]{handler.getUid()});
                registry.addRecipeCategories(new IRecipeCategory[]{handler});
                for (IMachineRecipe recipe : machine.recipes_registry) {
                    List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, List<FluidStack>>>> jeiInputItemExamples = recipe.getJEIInputItemExamples();
                    List collect = jeiInputItemExamples.stream().map(mapMapPair -> new JEIMachine.JEIMachineRecipe(machine, recipe, (Map)mapMapPair.getLeft(), (Map)mapMapPair.getRight())).collect(Collectors.toList());
                    if (!collect.isEmpty()) {
                        registry.addRecipes(collect);
                        continue;
                    }
                    long l = 0L;
                }
            }
        }
        registry.addRecipeHandlers(new IRecipeHandler[]{new JEIVanillaCraftingRecipeHandler<EnchantRecipe>(EnchantRecipe.class)});
        if (XU2Entries.unstableIngots.isActive()) {
            registry.addRecipeHandlers(new IRecipeHandler[]{new JEIVanillaCraftingRecipeHandler<ItemUnstableIngots.UnstableIngotRecipe>(ItemUnstableIngots.UnstableIngotRecipe.class)});
        }
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new IAdvancedGuiHandler<DynamicGui>(){

            @Nonnull
            public Class<DynamicGui> getGuiContainerClass() {
                return DynamicGui.class;
            }

            @Nullable
            public List<Rectangle> getGuiExtraAreas(@Nonnull DynamicGui gui) {
                ArrayList rectangles = Lists.newArrayList();
                for (DynamicWindow window : gui.container.getWindows()) {
                    rectangles.add(new Rectangle(gui.field_147003_i + window.x, gui.field_147009_r + window.y, window.w, window.h));
                }
                return rectangles;
            }

            @Nullable
            public Object getIngredientUnderMouse(@Nonnull DynamicGui guiContainer, int mouseX, int mouseY) {
                for (IWidget widget : guiContainer.container.getWidgets()) {
                    Object currentHeldStack;
                    if (!(widget instanceof IWidgetCustomJEIIngredient) || !guiContainer.isInArea(mouseX, mouseY, widget) || (currentHeldStack = ((IWidgetCustomJEIIngredient)((Object)widget)).getJEIIngredient()) == null) continue;
                    return currentHeldStack;
                }
                return null;
            }
        }});
        if (XU2Entries.indexer.enabled) {
            JEIIndexerTransfer.init(registry, registry.getRecipeTransferRegistry());
        }
        if (XU2Entries.blockCrafter.enabled) {
            registry.addRecipeCategoryCraftingItem(XU2Entries.blockCrafter.newStack(), new String[]{"minecraft.crafting"});
            IRecipeTransferHandler<TileCrafter.CrafterContainer> handler = new IRecipeTransferHandler<TileCrafter.CrafterContainer>(){

                @Nonnull
                public Class<TileCrafter.CrafterContainer> getContainerClass() {
                    return TileCrafter.CrafterContainer.class;
                }

                @Nonnull
                public String getRecipeCategoryUid() {
                    return "minecraft.crafting";
                }

                @Nullable
                public IRecipeTransferError transferRecipe(@Nonnull TileCrafter.CrafterContainer container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
                    if (!doTransfer) {
                        return null;
                    }
                    Map guiIngredients = recipeLayout.getItemStacks().getGuiIngredients();
                    for (int i = 0; i < 9; ++i) {
                        List allIngredients;
                        IGuiIngredient value = (IGuiIngredient)guiIngredients.get(1 + i);
                        ItemStack stack = value != null ? (!(allIngredients = value.getAllIngredients()).isEmpty() ? (ItemStack)allIngredients.get(0) : StackHelper.empty()) : StackHelper.empty();
                        WidgetSlotGhost ghostSlot = container.ghostSlots[i];
                        int widgetID = container.getWidgets().indexOf(ghostSlot);
                        NetworkHandler.sendPacketToServer(new DynamicContainer.PacketSetGhost(container.field_75152_c, widgetID, stack));
                    }
                    return null;
                }
            };
            registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)handler, "minecraft.crafting");
            guiHelper = registry.getJeiHelpers().getGuiHelper();
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        WidgetProgressArrowNetworkBase.setCategory = t -> jeiRuntime.getRecipesGui().showCategories((List)ImmutableList.of((Object)t));
        TileTerraformerClimograph.lookUpRecipes = t -> jeiRuntime.getRecipesGui().show(jeiRuntime.getRecipeRegistry().createFocus(IFocus.Mode.INPUT, t));
        final IItemListOverlay itemListOverlay = jeiRuntime.getItemListOverlay();
        if (XU2Entries.indexer.enabled) {
            TileIndexer.ContainerIndexer.textInterface = new TileIndexer.ContainerIndexer.JeiTextInterface(){

                @Override
                @Nonnull
                public String getFilterText() {
                    return itemListOverlay.getFilterText();
                }

                @Override
                public void setFilterText(@Nonnull String text) {
                    itemListOverlay.setFilterText(text);
                }
            };
        }
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }

    public class SubType
    implements ISubtypeRegistry.ISubtypeInterpreter,
    Function<ItemStack, String> {
        HashSet<String> types;

        @Override
        @Nonnull
        public String apply(@Nonnull ItemStack itemStack) {
            String subtypeInfo = this.getSubtypeInfo(itemStack);
            return subtypeInfo == null ? "" : subtypeInfo;
        }

        @Nullable
        public String getSubtypeInfo(@Nonnull ItemStack itemStack) {
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound == null) {
                return null;
            }
            return null;
        }
    }

    private static class UnstableIIngotInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter,
    Function<ItemStack, String> {
        private UnstableIIngotInterpreter() {
        }

        @Override
        @Nonnull
        public String apply(@Nonnull ItemStack itemStack) {
            String subtypeInfo = this.getSubtypeInfo(itemStack);
            return subtypeInfo == null ? "" : subtypeInfo;
        }

        @Nullable
        public String getSubtypeInfo(@Nonnull ItemStack itemStack) {
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound != null && tagCompound.func_150297_b("time", 99)) {
                return "primed";
            }
            return "";
        }
    }

    private static class MachineSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter,
    Function<ItemStack, String> {
        private MachineSubtypeInterpreter() {
        }

        @Override
        @Nonnull
        public String apply(@Nonnull ItemStack itemStack) {
            String subtypeInfo = this.getSubtypeInfo(itemStack);
            return subtypeInfo == null ? "" : subtypeInfo;
        }

        @Nullable
        public String getSubtypeInfo(@Nonnull ItemStack itemStack) {
            if (!itemStack.func_77942_o()) {
                return "machine[blank]";
            }
            Machine machineType = ItemBlockMachine.getMachineType(itemStack);
            return "machine[" + (machineType != null ? machineType.name : "unknown") + "]";
        }
    }
}

