/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.modcompat;

import com.rwtema.extrautils2.fluids.TexturePlasma;
import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.utils.datastructures.IntPair;
import com.rwtema.extrautils2.utils.helpers.CIELabHelper;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Validate;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public abstract class XUTConTextureBase
extends AbstractColoredTexture {
    static final IntPair[] directNeighbours = new IntPair[]{IntPair.of(1, 0), IntPair.of(0, 1), IntPair.of(-1, 0), IntPair.of(0, -1)};
    private static final IntPair[] offsets = new IntPair[]{IntPair.of(0, 1), IntPair.of(1, 1), IntPair.of(1, 0), IntPair.of(1, -1), IntPair.of(0, -1), IntPair.of(-1, -1), IntPair.of(-1, 0), IntPair.of(-1, 1)};
    int min;
    int max;
    private HashMap<IntPair, Integer> colorOverrides;
    private HashMap<IntPair, Integer> valueOverrides;
    private int[] colorPalette = null;

    protected XUTConTextureBase(ResourceLocation baseTexture, String spriteName) {
        super(baseTexture, spriteName);
    }

    protected XUTConTextureBase(String baseTextureLocation, String spriteName) {
        super(new ResourceLocation(baseTextureLocation), spriteName);
    }

    public static boolean[] invert(boolean[] data) {
        boolean[] data2 = new boolean[data.length];
        for (int i = 0; i < data.length; ++i) {
            data2[i] = !data[i];
        }
        return data2;
    }

    public static boolean[] filter(int[] data, int level) {
        boolean[] t = new boolean[data.length];
        for (int i = 0; i < data.length; ++i) {
            t[i] = data[i] == level;
        }
        return t;
    }

    public static boolean[] filterUp(int[] data, int level) {
        boolean[] t = new boolean[data.length];
        for (int i = 0; i < data.length; ++i) {
            t[i] = data[i] >= level;
        }
        return t;
    }

    public static boolean[] filterDown(int[] data, int level) {
        boolean[] t = new boolean[data.length];
        for (int i = 0; i < data.length; ++i) {
            t[i] = data[i] <= level;
        }
        return t;
    }

    private static int coord(int x, int y, int w, int h) {
        if (x < 0 || y < 0 || x >= w || y >= h) {
            return -1;
        }
        return y * w + x;
    }

    public static int getBrightness(int pixel) {
        return ColorHelper.brightness(TexturePlasma.directColorModel.getRed(pixel), TexturePlasma.directColorModel.getGreen(pixel), TexturePlasma.directColorModel.getBlue(pixel));
    }

    private static void check(int[] edges, int[] data, int x, int y, int w, int h) {
        int coord = XUTConTextureBase.coord(x, y, w, h);
        int col = data[coord];
        edges[coord] = col == 0 || TexturePlasma.directColorModel.getAlpha(col) < 32 ? 0 : 1;
    }

    private static void logImg(int[] levels, int width, int height) {
        if (!LogHelper.isDeObf) {
            return;
        }
        StringBuilder builder = new StringBuilder("\n");
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int level = levels[XUTConTextureBase.coord(x, y, width, height)];
                if (level < 0) {
                    builder.append(' ');
                    continue;
                }
                builder.append(CollectionHelper.CHAR_DIGITS[level]);
            }
            builder.append('\n');
        }
        LogHelper.debug(builder.toString(), new Object[0]);
    }

    public static int[] getEdgeDist(int[] data, int width, int height) {
        boolean incomplete;
        int x;
        int[] edges = new int[width * height];
        for (int i = 0; i < edges.length; ++i) {
            edges[i] = -1;
        }
        for (x = 0; x < width; ++x) {
            XUTConTextureBase.check(edges, data, x, 0, width, height);
            XUTConTextureBase.check(edges, data, x, height - 1, width, height);
        }
        for (int y = 1; y < height - 1; ++y) {
            XUTConTextureBase.check(edges, data, 0, y, width, height);
            XUTConTextureBase.check(edges, data, width - 1, y, width, height);
        }
        for (x = 1; x < width - 1; ++x) {
            for (int y = 1; y < height - 1; ++y) {
                int coord = XUTConTextureBase.coord(x, y, width, height);
                int col = data[coord];
                if (col != 0 && TexturePlasma.directColorModel.getAlpha(col) >= 32) continue;
                edges[coord] = 0;
            }
        }
        int[] prevValues = new int[edges.length];
        int[] curValues = edges;
        do {
            int[] t = prevValues;
            prevValues = curValues;
            curValues = t;
            incomplete = false;
            for (int x2 = 0; x2 < width; ++x2) {
                for (int y = 0; y < height; ++y) {
                    int coord = XUTConTextureBase.coord(x2, y, width, height);
                    if (prevValues[coord] == -1) {
                        incomplete = true;
                        int n = -1;
                        for (IntPair pair : directNeighbours) {
                            int otherN = prevValues[XUTConTextureBase.coord(x2 + pair.x, y + pair.y, width, height)];
                            if (otherN == -1) continue;
                            n = n == -1 ? otherN + 1 : Math.min(n, otherN + 1);
                        }
                        curValues[coord] = n;
                        continue;
                    }
                    curValues[coord] = prevValues[coord];
                }
            }
        } while (incomplete);
        return curValues;
    }

    public static boolean[] and(boolean[] ... inputArrays) {
        int length = inputArrays[0].length;
        for (int i = 1; i < inputArrays.length; ++i) {
            Validate.isTrue((inputArrays[i].length == length ? 1 : 0) != 0);
        }
        boolean[] c = new boolean[length];
        block1: for (int i = 0; i < length; ++i) {
            c[i] = true;
            for (boolean[] aT : inputArrays) {
                if (aT[i]) continue;
                c[i] = false;
                continue block1;
            }
        }
        return c;
    }

    public static boolean[] or(boolean[] ... inputArrays) {
        int length = inputArrays[0].length;
        for (int i = 1; i < inputArrays.length; ++i) {
            Validate.isTrue((inputArrays[i].length == length ? 1 : 0) != 0);
        }
        boolean[] c = new boolean[length];
        block1: for (int i = 0; i < length; ++i) {
            for (boolean[] aT : inputArrays) {
                if (!aT[i]) continue;
                c[i] = true;
                continue block1;
            }
        }
        return c;
    }

    public void logImg(boolean[] img) {
        int x;
        if (!LogHelper.isDeObf) {
            return;
        }
        StringBuilder builder = new StringBuilder("\n");
        builder.append('/');
        for (x = 0; x < this.field_130223_c; ++x) {
            builder.append('-');
        }
        builder.append('\\');
        for (x = 0; x < this.field_130223_c; ++x) {
            builder.append('|');
            for (int y = 0; y < this.field_130224_d; ++y) {
                builder.append(img[this.coord(x, y)] ? (char)'1' : ' ');
            }
            builder.append('|');
            builder.append('\n');
        }
        builder.append('\\');
        for (x = 0; x < this.field_130223_c; ++x) {
            builder.append('-');
        }
        builder.append('/');
        LogHelper.debug(builder.toString(), new Object[0]);
    }

    public void logImg(int[] levels) {
        int width = this.field_130223_c;
        int height = this.field_130224_d;
        XUTConTextureBase.logImg(levels, width, height);
    }

    protected void addColorPalette(int ... colorPalette) {
        this.colorPalette = colorPalette;
    }

    public void addOverrides(Map<IntPair, Integer> map, boolean[] filter, int color) {
        for (int x = 0; x < this.field_130223_c; ++x) {
            for (int y = 0; y < this.field_130224_d; ++y) {
                int coord = this.coord(x, y);
                if (!filter[coord]) continue;
                map.put(IntPair.of(x, y), color);
            }
        }
    }

    public boolean[] getCorners(boolean[] data) {
        boolean[] corners = new boolean[this.field_130223_c * this.field_130224_d];
        for (int x = 0; x < this.field_130223_c; ++x) {
            for (int y = 0; y < this.field_130224_d; ++y) {
                int i = XUTConTextureBase.coord(x, y, this.field_130223_c, this.field_130224_d);
                if (!data[i]) continue;
                int an = -1;
                int n = 0;
                for (IntPair offset : offsets) {
                    int coord2 = XUTConTextureBase.coord(x + offset.x, y + offset.y, this.field_130223_c, this.field_130224_d);
                    if (coord2 != -1 && data[coord2]) {
                        if (an == -1) {
                            an = n;
                        }
                        n = 0;
                        continue;
                    }
                    if (++n == 5) break;
                }
                if (an != -1) {
                    n += an;
                }
                if (n < 5) continue;
                corners[this.coord((int)x, (int)y)] = true;
            }
        }
        return corners;
    }

    public int[] getEdgeDist(int[] data) {
        int width = this.field_130223_c;
        int height = this.field_130224_d;
        return XUTConTextureBase.getEdgeDist(data, width, height);
    }

    protected IntPair toIntPair(int pxCoord) {
        int y = pxCoord / this.field_130223_c;
        int x = pxCoord - y * this.field_130223_c;
        return IntPair.of(x, y);
    }

    @Nullable
    protected <T> T getMipmapValue(HashMap<IntPair, T> map, int pxCoord, int mipmap) {
        if (mipmap == 0) {
            return map.get(this.toIntPair(pxCoord));
        }
        int y = pxCoord / this.field_130223_c;
        int x = pxCoord - y * this.field_130223_c;
        int n = 1 << mipmap;
        int prevD = -1;
        T curBest = null;
        for (int dx = 0; dx < n; ++dx) {
            for (int dy = 0; dy < n; ++dy) {
                IntPair pair = IntPair.of(x * n + dx, y * n + dy);
                T t = map.get(pair);
                if (t == null) continue;
                int d = (dx - n >> 2) * (dx - n >> 2) + (dy - n >> 2) * (dy - n >> 2);
                if (d == 0) {
                    return curBest;
                }
                if (prevD != -1 && d >= prevD) continue;
                curBest = t;
                prevD = d;
            }
        }
        return curBest;
    }

    protected void processData(int[] data) {
        this.valueOverrides = new HashMap();
        this.colorOverrides = new HashMap();
        this.preProcess(data, this.valueOverrides, this.colorOverrides);
        this.getLimits(data);
        super.processData(data);
        this.colorPalette = null;
        this.valueOverrides = null;
        this.colorOverrides = null;
    }

    private void getLimits(int[] data) {
        this.min = 255;
        this.max = 0;
        for (int x = 0; x < this.field_130223_c; ++x) {
            for (int y = 0; y < this.field_130224_d; ++y) {
                IntPair coord;
                int c = data[this.coord(x, y)];
                if (c == 0 || TexturePlasma.directColorModel.getAlpha(c) < 32 || this.valueOverrides.containsKey(coord = IntPair.of(x, y)) || this.colorOverrides.containsKey(coord)) continue;
                int brightness = XUTConTextureBase.getBrightness(c);
                this.min = Math.min(this.min, brightness);
                this.max = Math.max(this.max, brightness);
            }
        }
    }

    protected abstract void preProcess(int[] var1, Map<IntPair, Integer> var2, Map<IntPair, Integer> var3);

    protected boolean[] shift(boolean[] input, int dx, int dy) {
        boolean[] output = new boolean[input.length];
        for (int x = 0; x < this.field_130223_c; ++x) {
            for (int y = 0; y < this.field_130224_d; ++y) {
                int outCoord = XUTConTextureBase.coord(x + dx, y + dy, this.field_130223_c, this.field_130224_d);
                if (outCoord == -1) continue;
                output[outCoord] = input[this.coord(x, y)];
            }
        }
        return output;
    }

    protected boolean[] expand(boolean[] input) {
        boolean[] output = new boolean[input.length];
        for (int x = 0; x < this.field_130223_c; ++x) {
            for (int y = 0; y < this.field_130224_d; ++y) {
                if (!input[this.coord(x, y)]) continue;
                int n = this.coord(x, y);
                output[n] = output[n] | true;
                for (IntPair offset : offsets) {
                    int coord = XUTConTextureBase.coord(x + offset.x, y + offset.y, this.field_130223_c, this.field_130224_d);
                    if (coord == -1) continue;
                    int n2 = coord;
                    output[n2] = output[n2] | true;
                }
            }
        }
        return output;
    }

    protected int mean(int[] input) {
        int n = 0;
        int total = 0;
        boolean[] output = new boolean[input.length];
        for (int x = 0; x < this.field_130223_c; ++x) {
            for (int y = 0; y < this.field_130224_d; ++y) {
                int col = input[this.coord(x, y)];
                if (TexturePlasma.directColorModel.getAlpha(col) < 32) continue;
                int red = TexturePlasma.directColorModel.getRed(col);
                int green = TexturePlasma.directColorModel.getGreen(col);
                int blue = TexturePlasma.directColorModel.getBlue(col);
                int brightness = ColorHelper.brightness(red, green, blue);
                total += brightness;
                ++n;
            }
        }
        return total / n;
    }

    protected int colorPixel(int pixel, int pxCoord) {
        Integer valueOverride = this.getMipmapValue(this.valueOverrides, pxCoord, 0);
        if (valueOverride != null) {
            return valueOverride;
        }
        if (ColorHelper.getA(pixel) <= 0) {
            return 0;
        }
        Integer colorOverride = this.getMipmapValue(this.colorOverrides, pxCoord, 0);
        if (colorOverride != null) {
            return CIELabHelper.changeColor(pixel, colorOverride);
        }
        if (this.colorPalette != null) {
            if (pixel == 0 || TexturePlasma.directColorModel.getAlpha(pixel) < 32) {
                return 0;
            }
            if (this.min == this.max) {
                return this.colorPalette[0];
            }
            int brightness = XUTConTextureBase.getBrightness(pixel);
            float intensity = (float)(brightness - this.min) / (float)(this.max - this.min);
            return TexturePlasma.interpolate(intensity, this.colorPalette);
        }
        return pixel;
    }

    public static int multPixel(int col, int b) {
        return 0xFF000000 | MathHelper.func_76125_a((int)(TexturePlasma.directColorModel.getRed(col) * b / 255), (int)0, (int)255) << 16 | MathHelper.func_76125_a((int)(TexturePlasma.directColorModel.getGreen(col) * b / 255), (int)0, (int)255) << 8 | MathHelper.func_76125_a((int)(TexturePlasma.directColorModel.getBlue(col) * b / 255), (int)0, (int)255);
    }
}

