/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public interface IWorldPowerMultiplier {
    public static final IWorldPowerMultiplier CONSTANT = new IWorldPowerMultiplier(){

        @Override
        public float multiplier(World world) {
            return 1.0f;
        }

        public String toString() {
            return "CONSTANT";
        }
    };

    public float multiplier(@Nullable World var1);

    default public IWorldPowerMultiplier getStaticVariation() {
        return CONSTANT;
    }

    default public float alterTotal(float value) {
        return value;
    }

    default public boolean hasInefficiencies() {
        return false;
    }

    public static float capPower(float input, @Nullable TreeMap<Float, Pair<Float, Float>> efficiencyLevels) {
        if (efficiencyLevels == null || efficiencyLevels.isEmpty() || input < efficiencyLevels.firstKey().floatValue()) {
            return input;
        }
        Map.Entry<Float, Pair<Float, Float>> calc = efficiencyLevels.floorEntry(Float.valueOf(input));
        if (calc == null) {
            return input;
        }
        return ((Float)calc.getValue().getKey()).floatValue() + (input - calc.getKey().floatValue()) * ((Float)calc.getValue().getValue()).floatValue();
    }

    public static TreeMap<Float, Pair<Float, Float>> createCapsTree(float[][] caps) {
        if (caps.length == 0) {
            return null;
        }
        TreeMap<Float, Pair<Float, Float>> map = new TreeMap<Float, Pair<Float, Float>>();
        float curTotal = caps[0][0];
        if (curTotal != 0.0f) {
            map.put(Float.valueOf(0.0f), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f)));
        }
        for (int i = 0; i < caps.length; ++i) {
            float prevLower = caps[i][0];
            float multiplier = caps[i][1];
            map.put(Float.valueOf(prevLower), (Pair<Float, Float>)Pair.of((Object)Float.valueOf(curTotal), (Object)Float.valueOf(multiplier)));
            if (i + 1 >= caps.length) continue;
            float nextLevel = caps[i + 1][0];
            curTotal += (nextLevel - prevLower) * multiplier;
        }
        return map;
    }
}

