/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class FacingHelper {
    public static final EnumMap<EnumFacing, EnumSet<EnumFacing>> orthogonal = CollectionHelper.populateEnumMultiMap(EnumFacing.class, (facing, facing2) -> facing.func_176740_k() != facing2.func_176740_k());
    public static final EnumMap<EnumFacing, BiFunction<AxisAlignedBB, Double, AxisAlignedBB>> aabbsetters = new EnumMap(ImmutableMap.builder().put((Object)EnumFacing.DOWN, (b, t) -> new AxisAlignedBB(b.field_72340_a, t.doubleValue(), b.field_72339_c, b.field_72336_d, b.field_72337_e, b.field_72334_f)).put((Object)EnumFacing.UP, (b, t) -> new AxisAlignedBB(b.field_72340_a, b.field_72338_b, b.field_72339_c, b.field_72336_d, t.doubleValue(), b.field_72334_f)).put((Object)EnumFacing.NORTH, (b, t) -> new AxisAlignedBB(b.field_72340_a, b.field_72338_b, t.doubleValue(), b.field_72336_d, b.field_72337_e, b.field_72334_f)).put((Object)EnumFacing.SOUTH, (b, t) -> new AxisAlignedBB(b.field_72340_a, b.field_72338_b, b.field_72339_c, b.field_72336_d, b.field_72337_e, t.doubleValue())).put((Object)EnumFacing.WEST, (b, t) -> new AxisAlignedBB(t.doubleValue(), b.field_72338_b, b.field_72339_c, b.field_72336_d, b.field_72337_e, b.field_72334_f)).put((Object)EnumFacing.EAST, (b, t) -> new AxisAlignedBB(b.field_72340_a, b.field_72338_b, b.field_72339_c, t.doubleValue(), b.field_72337_e, b.field_72334_f)).build());
    public static final EnumMap<EnumFacing, ToIntFunction<BlockPos>> blockFaceGetters = new EnumMap(ImmutableMap.builder().put((Object)EnumFacing.DOWN, t -> t.func_177956_o()).put((Object)EnumFacing.UP, t -> t.func_177956_o() + 1).put((Object)EnumFacing.NORTH, t -> t.func_177952_p()).put((Object)EnumFacing.SOUTH, t -> t.func_177952_p() + 1).put((Object)EnumFacing.WEST, t -> t.func_177958_n()).put((Object)EnumFacing.EAST, t -> t.func_177958_n() + 1).build());
    public static final EnumMap<EnumFacing.Axis, ToIntFunction<BlockPos>> blockPosGetters = new EnumMap(ImmutableMap.builder().put((Object)EnumFacing.Axis.Y, Vec3i::func_177956_o).put((Object)EnumFacing.Axis.X, Vec3i::func_177958_n).put((Object)EnumFacing.Axis.Z, Vec3i::func_177952_p).build());
    public static final EnumMap<EnumFacing, ToDoubleFunction<AxisAlignedBB>> aabbGetters = new EnumMap(ImmutableMap.builder().put((Object)EnumFacing.DOWN, t -> t.field_72338_b).put((Object)EnumFacing.UP, t -> t.field_72337_e).put((Object)EnumFacing.NORTH, t -> t.field_72339_c).put((Object)EnumFacing.SOUTH, t -> t.field_72334_f).put((Object)EnumFacing.WEST, t -> t.field_72340_a).put((Object)EnumFacing.EAST, t -> t.field_72336_d).build());
    public static final EnumMap<EnumFacing, List<EnumFacing>> lists = CollectionHelper.populateEnumMap(EnumFacing.class, ImmutableList::of);
    public static final EnumMap<EnumFacing, EnumSet<EnumFacing>> nonEqual = CollectionHelper.populateEnumMultiMap(EnumFacing.class, (facing, facing2) -> facing != facing2);
    public static final EnumMap<EnumFacing, EnumSet<EnumFacing>> horizontalOrthogonal = CollectionHelper.populateEnumMultiMap(EnumFacing.class, (facing, facing2) -> facing.func_176740_k() != facing2.func_176740_k() && facing2.func_176740_k() != EnumFacing.Axis.Y);
    public static final EnumFacing[] facingPlusNull = new EnumFacing[]{null, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.NORTH};
    private static final Random r = new Random();
    private static final EnumFacing[] facingValues = EnumFacing.values();
    public static EnumFacing[][] randOrders;

    public static Iterable<EnumFacing> getRandomFaceOrder() {
        return new FaceIterRandom();
    }

    public static EnumFacing getDirectionFromEntityLiving(BlockPos pos, EntityLivingBase placer) {
        if (Math.abs(placer.field_70165_t - (double)((float)pos.func_177958_n() + 0.5f)) < 2.0 && Math.abs(placer.field_70161_v - (double)((float)pos.func_177952_p() + 0.5f)) < 2.0) {
            double d0 = placer.field_70163_u + (double)placer.func_70047_e();
            if (d0 - (double)pos.func_177956_o() > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)pos.func_177956_o() - d0 > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return placer.func_174811_aO().func_176734_d();
    }

    static {
        EnumFacing[] base = EnumFacing.values();
        randOrders = new EnumFacing[12][6];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                int k = (i + j) % 6;
                FacingHelper.randOrders[i * 2][j] = base[k];
                FacingHelper.randOrders[i * 2 + 1][j] = base[5 - k];
            }
        }
    }

    private static class FaceIterRandom
    implements Iterable<EnumFacing>,
    Iterator<EnumFacing> {
        byte[] b = new byte[]{0, 1, 2, 3, 4, 5};
        byte i = 0;

        private FaceIterRandom() {
        }

        @Override
        public Iterator<EnumFacing> iterator() {
            this.i = 0;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.i < 6;
        }

        @Override
        public EnumFacing next() {
            if (this.i == 5) {
                this.i = (byte)(this.i + 1);
                return facingValues[this.b[5]];
            }
            int k = this.i + r.nextInt(6 - this.i);
            if (k == this.i) {
                this.i = (byte)(this.i + 1);
                return facingValues[this.b[k]];
            }
            byte t = this.b[k];
            this.b[k] = this.b[this.i];
            this.b[this.i] = t;
            this.i = (byte)(this.i + 1);
            return facingValues[t];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

