/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import java.util.function.IntPredicate;
import java.util.function.Predicate;

public class LazyBitSet {
    long calc;
    long result;
    final IntPredicate predicate;

    public LazyBitSet(IntPredicate predicate) {
        this.predicate = predicate;
    }

    public boolean get(int bitIndex) {
        long mask = 1L << bitIndex;
        if ((this.calc & mask) == 0L) {
            this.calc |= mask;
            this.result = this.predicate.test(bitIndex) ? (this.result |= mask) : (this.result &= mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return (this.result & mask) != 0L;
    }

    public void invalidateAll() {
        this.calc = 0L;
    }

    public void invalide(int bitIndex) {
        this.calc &= (long)(1 << bitIndex);
    }

    public static class EnumBits<T extends Enum<T>>
    extends LazyBitSet {
        public EnumBits(Class<T> clazz, Predicate<T> predicate) {
            super(t -> predicate.test(((Enum[])clazz.getEnumConstants())[t]));
        }

        public boolean get(T t) {
            return this.get((T)((Enum)t).ordinal());
        }
    }
}

