/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.block;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.block.Trait;
import pl.asie.charset.lib.utils.ItemUtils;

public abstract class TraitItemHolder
extends Trait {
    private ItemStackHandler handler = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TraitItemHolder.this.onContentsChanged();
        }
    };

    public void onContentsChanged() {
    }

    public abstract boolean isStackAllowed(ItemStack var1);

    public abstract EnumFacing getTop();

    public ItemStack getStack() {
        return this.handler.getStackInSlot(0);
    }

    public IItemHandler getHandler() {
        return this.handler;
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        this.handler.deserializeNBT(compound);
    }

    @Override
    public NBTTagCompound writeNBTData(boolean isClient) {
        return this.handler.serializeNBT();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getTop();
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handler);
        }
        return null;
    }

    public boolean activate(TileBase parent, EntityPlayer player, EnumFacing side, EnumHand hand) {
        if (side == this.getTop() && hand == EnumHand.MAIN_HAND) {
            if (!this.getStack().func_190926_b()) {
                if (!parent.func_145831_w().field_72995_K) {
                    ItemUtils.giveOrSpawnItemEntity(player, parent.func_145831_w(), new Vec3d((Vec3i)parent.func_174877_v()).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d(this.getTop().func_176730_m()).func_186678_a(0.5)), this.getStack(), 0.0f, 0.0f, 0.0f, 0.0f, true);
                    this.setStack(ItemStack.field_190927_a);
                }
                return true;
            }
            ItemStack held = player.func_184586_b(hand);
            if (!held.func_190926_b() && this.isStackAllowed(held)) {
                if (!parent.func_145831_w().field_72995_K) {
                    this.setStack(held.func_77979_a(1));
                }
                return true;
            }
        }
        return false;
    }

    public void setStack(ItemStack stack) {
        this.handler.setStackInSlot(0, stack);
    }
}

