/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify.component;

import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.translation.I18n;
import pl.asie.charset.lib.notify.component.NotificationComponent;
import pl.asie.charset.lib.notify.component.NotificationComponentFactory;
import pl.asie.charset.lib.notify.component.NotificationComponentUtil;

public class NotificationComponentString
extends NotificationComponent {
    private final boolean format;
    private final String string;
    private final NotificationComponent[] components;

    protected NotificationComponentString(boolean format, String s, NotificationComponent ... components) {
        this.format = format;
        this.string = s;
        this.components = components;
    }

    public static NotificationComponentString translated(String s, NotificationComponent ... components) {
        return new NotificationComponentString(true, s, components);
    }

    public static NotificationComponentString raw(String s, NotificationComponent ... components) {
        return new NotificationComponentString(false, s, components);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof NotificationComponentString)) {
            return false;
        }
        NotificationComponentString ncs = (NotificationComponentString)other;
        if (this.format != ncs.format || !this.string.equals(ncs.string)) {
            return false;
        }
        if (this.components.length != ncs.components.length) {
            return false;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].equals(ncs.components[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.format) {
            String[] strings = new String[this.components.length];
            for (int i = 0; i < this.components.length; ++i) {
                strings[i] = this.components[i].toString();
            }
            return I18n.func_74837_a((String)this.string, (Object[])strings);
        }
        return String.format(this.string, this.components);
    }

    public static class Factory
    implements NotificationComponentFactory<NotificationComponentString> {
        @Override
        public Class<NotificationComponentString> getComponentClass() {
            return NotificationComponentString.class;
        }

        @Override
        public void serialize(NotificationComponentString component, PacketBuffer buffer) {
            buffer.writeBoolean(component.format);
            buffer.func_180714_a(component.string);
            buffer.func_150787_b(component.components.length);
            for (NotificationComponent c : component.components) {
                NotificationComponentUtil.serialize(c, buffer);
            }
        }

        @Override
        public NotificationComponentString deserialize(PacketBuffer buffer) {
            boolean f = buffer.readBoolean();
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int l = buffer.func_150792_a();
            NotificationComponent[] cps = new NotificationComponent[l];
            for (int i = 0; i < l; ++i) {
                cps[i] = NotificationComponentUtil.deserialize(buffer);
            }
            return new NotificationComponentString(f, s, cps);
        }
    }
}

