/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.render.sprite.SpritesheetFactory;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireRenderHandler;

public class WireRenderHandlerDefault
extends WireRenderHandler {
    private final String domain;
    private final String path;
    @Nonnull
    private TextureAtlasSprite[] top;
    @Nullable
    private TextureAtlasSprite side;
    @Nullable
    private TextureAtlasSprite edge;
    @Nullable
    private TextureAtlasSprite corner;

    public WireRenderHandlerDefault(WireProvider provider) {
        super(provider);
        ResourceLocation location = provider.getTexturePrefix();
        this.domain = location.func_110624_b();
        this.path = !location.func_110623_a().endsWith("/") ? location.func_110623_a() + "_" : location.func_110623_a();
    }

    @Override
    public boolean isTranslucent() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void refresh(TextureMap map) {
        this.top = SpritesheetFactory.register(map, new ResourceLocation(this.domain, this.path + "top"), 4, 4);
        if (!this.provider.isFlat()) {
            this.edge = map.func_174942_a(new ResourceLocation(this.domain, this.path + "edge"));
            this.side = map.func_174942_a(new ResourceLocation(this.domain, this.path + "side"));
            this.corner = map.func_174942_a(new ResourceLocation(this.domain, this.path + "corner"));
        } else {
            this.edge = null;
            this.side = null;
            this.corner = null;
        }
    }

    @Override
    public TextureAtlasSprite getTexture(WireRenderHandler.TextureType type, Wire wire, @Nullable EnumFacing facing, int connMask) {
        switch (type) {
            case TOP: {
                return this.top[connMask & 0xF];
            }
            case SIDE: {
                return this.side;
            }
            case EDGE: {
                return this.edge;
            }
            case CORNER: {
                return this.corner;
            }
        }
        return this.top[15];
    }

    @Override
    public int getColor(WireRenderHandler.TextureType type, Wire wire, @Nullable EnumFacing direction) {
        return wire.getRenderColor();
    }
}

