/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.IPistonCallback;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;

public class PistonsMoveTEs
extends Feature {
    private static WeakHashMap<World, Map<BlockPos, TileEntity>> movements = new WeakHashMap();
    private static WeakHashMap<World, List<Pair<BlockPos, TileEntity>>> delayedUpdates = new WeakHashMap();
    public static List<String> renderBlacklist;
    public static List<String> movementBlacklist;
    public static List<String> delayedUpdateList;

    @Override
    public void setupConfig() {
        String[] renderBlacklistArray = this.loadPropStringList("Tile Entity Render Blacklist", "Some mod blocks with complex renders will break everything if moved. Add them here if you find any.", new String[]{"psi:programmer", "botania:starfield"});
        String[] movementBlacklistArray = this.loadPropStringList("Tile Entity Movement Blacklist", "Blocks with Tile Entities that pistons should not be able to move.\nYou can specify just mod names here, and all blocks from that mod will be disabled.", new String[]{"minecraft:mob_spawner", "integrateddynamics:cable"});
        String[] delayedUpdateListArray = this.loadPropStringList("Delayed Update List", "List of blocks whose tile entity update should be delayed by one tick after placed to prevent corruption.", new String[]{"minecraft:dispenser", "minecraft:dropper"});
        renderBlacklist = new ArrayList<String>(Arrays.asList(renderBlacklistArray));
        movementBlacklist = new ArrayList<String>(Arrays.asList(movementBlacklistArray));
        delayedUpdateList = new ArrayList<String>(Arrays.asList(delayedUpdateListArray));
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!delayedUpdates.containsKey(event.world) || event.phase == TickEvent.Phase.START) {
            return;
        }
        List<Pair<BlockPos, TileEntity>> delays = delayedUpdates.get(event.world);
        if (delays.isEmpty()) {
            return;
        }
        for (Pair<BlockPos, TileEntity> delay : delays) {
            event.world.func_175690_a((BlockPos)delay.getLeft(), (TileEntity)delay.getRight());
            ((TileEntity)delay.getRight()).func_145836_u();
        }
        delays.clear();
    }

    public static boolean shouldMoveTE(boolean te, IBlockState state) {
        if (!ModuleLoader.isFeatureEnabled(PistonsMoveTEs.class)) {
            return te;
        }
        if (state.func_177227_a().contains(BlockJukebox.field_176432_a) && ((Boolean)state.func_177229_b((IProperty)BlockJukebox.field_176432_a)).booleanValue()) {
            return true;
        }
        ResourceLocation res = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c());
        return movementBlacklist.contains(res.toString()) || movementBlacklist.contains(res.func_110624_b());
    }

    public static void detachTileEntities(World world, BlockPos sourcePos, List<BlockPos> moveList, List<BlockPos> destroyList, EnumFacing facing, boolean extending) {
        if (!ModuleLoader.isFeatureEnabled(PistonsMoveTEs.class)) {
            return;
        }
        for (BlockPos pos : moveList) {
            IBlockState state = world.func_180495_p(pos);
            if (!state.func_177230_c().hasTileEntity(state)) continue;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IPistonCallback) {
                ((IPistonCallback)tile).onPistonMovementStarted();
            }
            world.func_175713_t(pos);
            PistonsMoveTEs.registerMovement(world, pos.func_177972_a(facing), tile);
        }
    }

    public static boolean setPistonBlock(World world, BlockPos pos, IBlockState state, int flags) {
        if (!ModuleLoader.isFeatureEnabled(PistonsMoveTEs.class)) {
            world.func_180501_a(pos, state, flags);
            return false;
        }
        Block block = state.func_177230_c();
        TileEntity tile = PistonsMoveTEs.getAndClearMovement(world, pos);
        boolean destroyed = false;
        if (tile != null) {
            IBlockState currState = world.func_180495_p(pos);
            TileEntity currTile = world.func_175625_s(pos);
            world.func_175698_g(pos);
            if (!block.func_176196_c(world, pos)) {
                world.func_180501_a(pos, state, flags);
                world.func_175690_a(pos, tile);
                block.func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
                destroyed = true;
            }
            if (!destroyed) {
                world.func_175656_a(pos, currState);
                world.func_175690_a(pos, currTile);
            }
        }
        if (!destroyed) {
            world.func_180501_a(pos, state, flags);
            if (world.func_175625_s(pos) != null) {
                world.func_180501_a(pos, state, 0);
            }
            if (tile != null && !world.field_72995_K) {
                if (delayedUpdateList.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString())) {
                    PistonsMoveTEs.registerDelayedUpdate(world, pos, tile);
                } else {
                    world.func_175690_a(pos, tile);
                    tile.func_145836_u();
                }
            }
            world.func_175685_c(pos, block, true);
        }
        return false;
    }

    private static void registerMovement(World world, BlockPos pos, TileEntity tile) {
        if (!movements.containsKey(world)) {
            movements.put(world, new HashMap());
        }
        movements.get(world).put(pos, tile);
    }

    public static TileEntity getMovement(World world, BlockPos pos) {
        return PistonsMoveTEs.getMovement(world, pos, false);
    }

    private static TileEntity getMovement(World world, BlockPos pos, boolean remove) {
        if (!movements.containsKey(world)) {
            return null;
        }
        Map<BlockPos, TileEntity> worldMovements = movements.get(world);
        if (!worldMovements.containsKey(pos)) {
            return null;
        }
        TileEntity ret = worldMovements.get(pos);
        if (remove) {
            worldMovements.remove(pos);
        }
        return ret;
    }

    private static TileEntity getAndClearMovement(World world, BlockPos pos) {
        TileEntity tile = PistonsMoveTEs.getMovement(world, pos, true);
        if (tile != null) {
            if (tile instanceof IPistonCallback) {
                ((IPistonCallback)tile).onPistonMovementFinished();
            }
            tile.func_145829_t();
            if (tile instanceof TileEntityChest) {
                ((TileEntityChest)tile).field_145987_o = 0;
            }
        }
        return tile;
    }

    private static void registerDelayedUpdate(World world, BlockPos pos, TileEntity tile) {
        if (!delayedUpdates.containsKey(world)) {
            delayedUpdates.put(world, new ArrayList());
        }
        delayedUpdates.get(world).add((Pair<BlockPos, TileEntity>)Pair.of((Object)pos, (Object)tile));
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureIngameConfigName() {
        return "Pistons Move TEs";
    }
}

