/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.feature;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageDeleteItem;
import vazkii.quark.management.client.gui.GuiButtonTrash;
import vazkii.quark.management.feature.FavoriteItems;

public class DeleteItems
extends Feature {
    boolean keyboardDown = false;
    boolean mouseDown = false;
    GuiButtonTrash trash;
    boolean trashButton;
    boolean playerInvOnly;
    int trashButtonX;
    int trashButtonY;

    @Override
    public void setupConfig() {
        this.trashButton = this.loadPropBool("Enable Trash Button", "", true);
        this.playerInvOnly = this.loadPropBool("Trash Button only on Player Inventory", "", false);
        this.trashButtonX = this.loadPropInt("Trash Button X", "", 3);
        this.trashButtonY = this.loadPropInt("Trash Button Y", "", -25);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        this.trash = null;
        if (event.getGui() instanceof GuiContainer && this.trashButton) {
            GuiContainer guiInv = (GuiContainer)event.getGui();
            Container container = guiInv.field_147002_h;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            boolean isPlayerInv = guiInv instanceof GuiInventory;
            boolean creative = player.func_184812_l_();
            if (creative || !isPlayerInv && this.playerInvOnly) {
                return;
            }
            int guiWidth = guiInv.getXSize();
            int guiHeight = guiInv.getYSize();
            this.trash = new GuiButtonTrash((GuiScreen)guiInv, 82424, guiWidth, guiHeight + this.trashButtonY);
            event.getButtonList().add(this.trash);
        }
    }

    @SubscribeEvent
    public void mouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        boolean oldMouseDown = this.mouseDown;
        this.mouseDown = Mouse.isButtonDown((int)0);
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        if (this.mouseDown != oldMouseDown && current instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)current;
            if (this.trash != null && this.trash.ready) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDeleteItem(-1));
                event.setCanceled(true);
                mc.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            }
        }
    }

    @SubscribeEvent
    public void keyboardEvent(GuiScreenEvent.KeyboardInputEvent.Post event) {
        IInventory inv;
        GuiContainer gui;
        Slot slot;
        boolean down = Keyboard.isKeyDown((int)211);
        if (GuiScreen.func_146271_m() && down && !this.keyboardDown && event.getGui() instanceof GuiContainer && (slot = (gui = (GuiContainer)event.getGui()).getSlotUnderMouse()) != null && (inv = slot.field_75224_c) instanceof InventoryPlayer) {
            int index = slot.getSlotIndex();
            if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && index >= 36) {
                index -= 36;
            }
            if (index < ((InventoryPlayer)inv).field_70462_a.size()) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDeleteItem(index));
            }
        }
        this.keyboardDown = down;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void update(TickEvent.ClientTickEvent event) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiContainer && this.trash != null) {
            GuiContainer inv = (GuiContainer)gui;
            this.trash.field_146128_h = inv.getGuiLeft() + this.trash.shiftX;
            this.trash.field_146129_i = inv.getGuiTop() + this.trash.shiftY;
        }
    }

    public static void deleteItem(EntityPlayer player, int slot) {
        ItemStack stack;
        if (slot > player.field_71071_by.field_70462_a.size()) {
            return;
        }
        ItemStack itemStack = stack = slot == -1 ? player.field_71071_by.func_70445_o() : player.field_71071_by.func_70301_a(slot);
        if (!DeleteItems.canItemBeDeleted(stack)) {
            return;
        }
        if (slot == -1) {
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        } else {
            player.field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
        }
    }

    public static boolean canItemBeDeleted(ItemStack stack) {
        return ModuleLoader.isFeatureEnabled(DeleteItems.class) && !stack.func_190926_b() && !FavoriteItems.isItemFavorited(stack);
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public String getFeatureIngameConfigName() {
        return "Delete Items";
    }
}

