/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.client.render.RenderExtraArrow;
import vazkii.quark.misc.entity.EntityArrowEnder;
import vazkii.quark.misc.entity.EntityArrowExplosive;
import vazkii.quark.misc.entity.EntityArrowTorch;
import vazkii.quark.misc.item.ItemModArrow;

public class ExtraArrows
extends Feature {
    public static Item arrow_ender;
    public static Item arrow_explosive;
    public static Item arrow_torch;
    boolean enableEnder;
    boolean enableExplosive;
    boolean enableTorch;
    public static double explosiveArrowPower;
    public static boolean explosiveArrowDestroysBlocks;

    @Override
    public void setupConfig() {
        this.enableEnder = this.loadPropBool("Enable Ender Arrow", "", true);
        this.enableExplosive = this.loadPropBool("Enable Explosive Arrow", "", true);
        this.enableTorch = this.loadPropBool("Enable Torch Arrow", "", true);
        explosiveArrowPower = this.loadPropDouble("Explosive Arrow Power", "", 2.0);
        explosiveArrowDestroysBlocks = this.loadPropBool("Explosive Arrow Destroys Blocks", "", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (this.enableEnder) {
            String enderArrowName = "quark:arrow_ender";
            arrow_ender = new ItemModArrow("arrow_ender", (worldIn, stack, shooter) -> new EntityArrowEnder(worldIn, shooter));
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(enderArrowName), EntityArrowEnder.class, (String)enderArrowName, (int)5, (Object)Quark.instance, (int)64, (int)10, (boolean)true);
            BlockDispenser.field_149943_a.func_82595_a((Object)arrow_ender, (Object)new ArrowBehaviour((world, pos) -> new EntityArrowEnder(world, pos)));
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Item)arrow_ender), (Object[])new Object[]{ProxyRegistry.newStack((Item)Items.field_151032_g), ProxyRegistry.newStack((Item)Items.field_151079_bi)});
        }
        if (this.enableExplosive) {
            String explosiveArrowName = "quark:arrow_explosive";
            arrow_explosive = new ItemModArrow("arrow_explosive", (worldIn, stack, shooter) -> new EntityArrowExplosive(worldIn, shooter));
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(explosiveArrowName), EntityArrowExplosive.class, (String)explosiveArrowName, (int)6, (Object)Quark.instance, (int)64, (int)10, (boolean)true);
            BlockDispenser.field_149943_a.func_82595_a((Object)arrow_explosive, (Object)new ArrowBehaviour((world, pos) -> new EntityArrowExplosive(world, pos)));
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Item)arrow_explosive), (Object[])new Object[]{ProxyRegistry.newStack((Item)Items.field_151032_g), ProxyRegistry.newStack((Item)Items.field_151016_H), ProxyRegistry.newStack((Item)Items.field_151016_H)});
        }
        if (this.enableTorch) {
            String torchArrowName = "quark:arrow_torch";
            arrow_torch = new ItemModArrow("arrow_torch", (worldIn, stack, shooter) -> new EntityArrowTorch(worldIn, shooter));
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(torchArrowName), EntityArrowTorch.class, (String)torchArrowName, (int)7, (Object)Quark.instance, (int)64, (int)10, (boolean)true);
            BlockDispenser.field_149943_a.func_82595_a((Object)arrow_torch, (Object)new ArrowBehaviour((world, pos) -> new EntityArrowTorch(world, pos)));
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Item)arrow_torch), (Object[])new Object[]{ProxyRegistry.newStack((Item)Items.field_151032_g), ProxyRegistry.newStack((Block)Blocks.field_150478_aa)});
        }
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        if (this.enableEnder) {
            RenderingRegistry.registerEntityRenderingHandler(EntityArrowEnder.class, (IRenderFactory)RenderExtraArrow.FACTORY_ENDER);
        }
        if (this.enableExplosive) {
            RenderingRegistry.registerEntityRenderingHandler(EntityArrowExplosive.class, (IRenderFactory)RenderExtraArrow.FACTORY_EXPLOSIVE);
        }
        if (this.enableTorch) {
            RenderingRegistry.registerEntityRenderingHandler(EntityArrowTorch.class, (IRenderFactory)RenderExtraArrow.FACTORY_TORCH);
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static class ArrowBehaviour
    extends BehaviorProjectileDispense {
        ArrowProvider provider;

        public ArrowBehaviour(ArrowProvider provider) {
            this.provider = provider;
        }

        protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
            EntityArrow arrow = this.provider.provide(worldIn, position);
            arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
            return arrow;
        }

        public static interface ArrowProvider {
            public EntityArrow provide(World var1, IPosition var2);
        }
    }
}

