/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emotes;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.player.EntityPlayer;
import vazkii.arl.util.ClientTicker;
import vazkii.aurelienribon.tweenengine.Timeline;
import vazkii.aurelienribon.tweenengine.TweenManager;
import vazkii.quark.vanity.client.emotes.EmoteDescriptor;
import vazkii.quark.vanity.client.emotes.EmoteState;

public abstract class EmoteBase {
    public static final float PI_F = (float)Math.PI;
    public final EmoteDescriptor desc;
    TweenManager emoteManager;
    private ModelBiped model;
    private ModelBiped armorModel;
    private ModelBiped armorLegsModel;
    private EmoteState state;
    private EntityPlayer player;
    public float timeDone;
    public float totalTime;
    public float animatedTime;

    public EmoteBase(EmoteDescriptor desc, EntityPlayer player, ModelBiped model, ModelBiped armorModel, ModelBiped armorLegsModel) {
        this.desc = desc;
        this.emoteManager = new TweenManager();
        this.state = new EmoteState(this);
        this.model = model;
        this.armorModel = armorModel;
        this.armorLegsModel = armorLegsModel;
        this.player = player;
    }

    public void startAllTimelines() {
        this.startTimeline(this.player, this.model);
        this.startTimeline(this.player, this.armorModel);
        this.startTimeline(this.player, this.armorLegsModel);
    }

    void startTimeline(EntityPlayer player, ModelBiped model) {
        Timeline timeline = (Timeline)this.getTimeline(player, model).start(this.emoteManager);
        this.totalTime = timeline.getFullDuration() / 50.0f;
    }

    public abstract Timeline getTimeline(EntityPlayer var1, ModelBiped var2);

    public abstract boolean usesBodyPart(int var1);

    public void update(boolean doUpdate) {
        this.state.load(this.model);
        this.state.load(this.armorModel);
        this.state.load(this.armorLegsModel);
        if (doUpdate) {
            float timeDiff = Math.max(Math.abs(this.animatedTime - this.timeDone), ClientTicker.delta);
            this.animatedTime += timeDiff;
            this.emoteManager.update(timeDiff * 50.0f);
            this.state.save(this.model);
        }
    }

    public void updateTime() {
        this.timeDone += ClientTicker.delta;
    }

    public boolean isDone() {
        return this.timeDone >= this.totalTime || this.player.field_70733_aJ > 0.0f || this.player.field_70737_aN > 0;
    }
}

