/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;

public class MushroomsInSwamps
extends Feature {
    private WorldGenerator bigMushroomGen = new WorldGenBigMushroom();
    double bigMushroomsPerChunk;

    @Override
    public void setupConfig() {
        this.bigMushroomsPerChunk = this.loadPropDouble("Big Mushroom count per chunk", "Must be an integer if above 1. If below 1, works as a chance to generate one per chunk.", 0.5);
    }

    @SubscribeEvent
    public void decorate(DecorateBiomeEvent.Decorate event) {
        World world = event.getWorld();
        Biome biome = world.func_180494_b(event.getPos());
        Random rand = event.getRand();
        if ((biome == Biomes.field_76780_h || biome == Biomes.field_150599_m) && event.getType() == DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM) {
            if (this.bigMushroomsPerChunk < 1.0 && rand.nextDouble() > this.bigMushroomsPerChunk) {
                return;
            }
            int amount = (int)Math.max(1.0, this.bigMushroomsPerChunk);
            for (int i = 0; i < amount; ++i) {
                int x = rand.nextInt(16) + 8;
                int y = rand.nextInt(16) + 8;
                this.bigMushroomGen.func_180709_b(world, rand, world.func_175645_m(event.getPos().func_177982_a(x, 0, y)));
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @Override
    public boolean hasTerrainSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureIngameConfigName() {
        return "Big Mushrooms In Swamps";
    }
}

