/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public interface IImmersiveConnectable {
    public boolean canConnect();

    public boolean isEnergyOutput();

    public int outputEnergy(int var1, boolean var2, int var3);

    public BlockPos getConnectionMaster(@Nullable WireType var1, TargetingInfo var2);

    @Deprecated
    default public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        return false;
    }

    default public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        return this.canConnectCable(cableType, target);
    }

    default public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other, @Nullable Vec3i offset) {
        this.connectCable(cableType, target, other);
    }

    default public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        this.connectCable(cableType, target, other, null);
    }

    public WireType getCableLimiter(TargetingInfo var1);

    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection var1);

    default public void onEnergyPassthrough(int amount) {
    }

    default public void onEnergyPassthrough(double amount) {
        this.onEnergyPassthrough((int)amount);
    }

    default public void addAvailableEnergy(float amount, Consumer<Float> consume) {
    }

    public void removeCable(@Nullable ImmersiveNetHandler.Connection var1);

    @Deprecated
    default public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        return new Vec3d(0.5, 0.5, 0.5);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection var1);

    default public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con, TargetingInfo target, Vec3i offsetLink) {
        return this.getConnectionOffset(con);
    }

    default public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)ApiUtils.toBlockPos(this));
    }

    default public float getDamageAmount(Entity e, ImmersiveNetHandler.Connection c) {
        return 0.0f;
    }

    default public void processDamage(Entity e, float amount, ImmersiveNetHandler.Connection c) {
    }

    default public void onConnectivityUpdate(BlockPos pos, int dimension) {
        if (ImmersiveNetHandler.INSTANCE.indirectConnections.containsKey(dimension)) {
            ((Map)ImmersiveNetHandler.INSTANCE.indirectConnections.get(dimension)).remove(pos);
        }
        if (ImmersiveNetHandler.INSTANCE.indirectConnectionsIgnoreOut.containsKey(dimension)) {
            ((Map)ImmersiveNetHandler.INSTANCE.indirectConnectionsIgnoreOut.get(dimension)).remove(pos);
        }
    }
}

