/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.lwjgl.input.Keyboard;

public class ItemEngineersBlueprint
extends ItemUpgradeableTool {
    public ItemEngineersBlueprint() {
        super("blueprint", 1, (String)null, new String[0]);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        String key = ItemNBTHelper.getString(stack, "blueprint");
        if (key != null && !key.isEmpty() && BlueprintCraftingRecipe.blueprintCategories.contains(key)) {
            String formatted;
            String formatKey = "desc.immersiveengineering.info.blueprint." + key;
            list.add(formatKey.equals(formatted = I18n.func_135052_a((String)formatKey, (Object[])new Object[0])) ? key : formatted);
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.blueprint.creates1", (Object[])new Object[0]));
                BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(key);
                if (recipes.length > 0) {
                    for (int i = 0; i < recipes.length; ++i) {
                        list.add(" " + recipes[i].output.func_82833_r());
                    }
                }
            } else {
                list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.blueprint.creates0", (Object[])new Object[0]));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (String key : BlueprintCraftingRecipe.blueprintCategories) {
                ItemStack stack = new ItemStack((Item)this);
                ItemNBTHelper.setString(stack, "blueprint", key);
                list.add((Object)stack);
            }
        }
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        LinkedHashSet<SlotItemHandler> slots = new LinkedHashSet<SlotItemHandler>();
        slots.add(new IESlot.BlueprintInput(container, inv, 0, 74, 21, stack));
        slots.add(new IESlot.BlueprintInput(container, inv, 1, 92, 21, stack));
        slots.add(new IESlot.BlueprintInput(container, inv, 2, 74, 39, stack));
        slots.add(new IESlot.BlueprintInput(container, inv, 3, 92, 39, stack));
        slots.add(new IESlot.BlueprintInput(container, inv, 4, 74, 57, stack));
        slots.add(new IESlot.BlueprintInput(container, inv, 5, 92, 57, stack));
        BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(stack, "blueprint"));
        for (int i = 0; i < recipes.length; ++i) {
            int y = 21 + (i < 9 ? i / 3 : -(i - 6) / 3) * 18;
            slots.add(new IESlot.BlueprintOutput(container, inv, 6 + i, 118 + i % 3 * 18, y, stack, recipes[i]));
        }
        return slots.toArray(new Slot[slots.size()]);
    }

    public void updateOutputs(ItemStack stack) {
        BlueprintCraftingRecipe[] recipes = BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(stack, "blueprint"));
        IItemHandlerModifiable handler = (IItemHandlerModifiable)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        NonNullList query = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (i < 6) {
                query.set(i, (Object)handler.getStackInSlot(i));
                continue;
            }
            handler.setStackInSlot(i, ItemStack.field_190927_a);
            int craftable = recipes[i - 6].getMaxCrafted((NonNullList<ItemStack>)query);
            if (craftable <= 0) continue;
            handler.setStackInSlot(i, Utils.copyStackWithAmount(recipes[i - 6].output, Math.min(recipes[i - 6].output.func_190916_E() * craftable, 64 - 64 % recipes[i - 6].output.func_190916_E())));
        }
    }

    public void reduceInputs(BlueprintCraftingRecipe recipe, ItemStack stack, ItemStack crafted, Container contained) {
        int i;
        IItemHandlerModifiable handler = (IItemHandlerModifiable)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        NonNullList query = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
        for (i = 0; i < 6; ++i) {
            query.set(i, (Object)handler.getStackInSlot(i));
        }
        recipe.consumeInputs((NonNullList<ItemStack>)query, crafted.func_190916_E() / recipe.output.func_190916_E());
        for (i = 0; i < 6; ++i) {
            handler.setStackInSlot(i, (ItemStack)query.get(i));
        }
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 6 + BlueprintCraftingRecipe.findRecipes(ItemNBTHelper.getString(stack, "blueprint")).length;
    }

    @Override
    public boolean canTakeFromWorkbench(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < 6; ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

