/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import paulscode.sound.ICodec;
import paulscode.sound.codecs.CodecIBXM;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import pl.asie.charset.lib.audio.codec.DFPWM;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.module.audio.storage.AudioDataDumperPaul;
import pl.asie.charset.module.audio.storage.AudioResampler;
import pl.asie.charset.module.audio.storage.CharsetAudioStorage;
import pl.asie.charset.module.audio.storage.IAudioDataDumper;
import pl.asie.charset.module.audio.storage.PacketDriveData;

public class AudioRecordThread
implements Runnable {
    private static final int PACKET_SIZE = 8192;
    private static final DFPWM CODEC = new DFPWM();
    private final File file;
    private final int maxSize;
    private int sampleRate;
    private String statusBar = "Encoding...";

    public static String[] getSupportedExtensions() {
        List<String> exts = AudioRecordThread.getSupportedExtensionList();
        return exts.toArray(new String[exts.size()]);
    }

    private static void addIfCodec(List<String> exts, String ext) {
        if (AudioRecordThread.getCodec(ext) != null) {
            exts.add(ext);
        }
    }

    public static List<String> getSupportedExtensionList() {
        ArrayList<String> exts = new ArrayList<String>();
        for (String s : new String[]{"ogg", "wav", "mod", "s3m", "xm"}) {
            AudioRecordThread.addIfCodec(exts, s);
        }
        if (Loader.isModLoaded((String)"notenoughcodecs")) {
            for (String s : new String[]{"aac", "mp3", "m4a", "mp4", "flac"}) {
                AudioRecordThread.addIfCodec(exts, s);
            }
        }
        return exts;
    }

    private static IAudioDataDumper getCodec(String ext) {
        try {
            AudioDataDumperPaul dumper = null;
            CodecJOrbis codec = null;
            if ("ogg".equals(ext)) {
                codec = new CodecJOrbis();
            } else if ("wav".equals(ext)) {
                codec = new CodecWav();
            } else if ("mod".equals(ext) || "s3m".equals(ext) || "xm".equals(ext)) {
                codec = new CodecIBXM();
            } else if ("mp3".equals(ext)) {
                codec = (ICodec)AudioRecordThread.class.getClassLoader().loadClass("openmods.codecs.adapters.CodecMP3").newInstance();
            } else if ("mp4".equals(ext) || "m4a".equals(ext)) {
                codec = (ICodec)AudioRecordThread.class.getClassLoader().loadClass("openmods.codecs.adapters.CodecMP4").newInstance();
            } else if ("aac".equals(ext)) {
                codec = (ICodec)AudioRecordThread.class.getClassLoader().loadClass("openmods.codecs.adapters.CodecADTS").newInstance();
            } else if ("flac".equals(ext)) {
                codec = (ICodec)AudioRecordThread.class.getClassLoader().loadClass("openmods.codecs.adapters.CodecFLAC").newInstance();
            }
            if (codec != null) {
                dumper = new AudioDataDumperPaul((ICodec)codec);
            }
            return dumper;
        }
        catch (Exception e) {
            return null;
        }
    }

    public AudioRecordThread(File f, int sampleRate, int maxSize) {
        this.file = f;
        this.sampleRate = sampleRate;
        this.maxSize = maxSize;
    }

    public String getStatusBar() {
        return this.statusBar != null ? this.statusBar : "???";
    }

    private void showError(String s) {
        this.statusBar = s;
        try {
            Thread.sleep(1250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            if (this.sampleRate <= 0) {
                this.showError("Must provide power!");
                return;
            }
            String ext = FilenameUtils.getExtension((String)this.file.getName()).toLowerCase();
            this.statusBar = "Loading...";
            IAudioDataDumper codec = AudioRecordThread.getCodec(ext);
            if (codec == null) {
                this.showError("Unsupported format!");
                return;
            }
            codec.initialize(this.file);
            if (!codec.initialized()) {
                this.showError("Failed to load!");
                return;
            }
            Pair<byte[], AudioFormat> pair = codec.getAudioData((long)this.maxSize * 8L * 1000L / (long)this.sampleRate);
            if (pair == null) {
                this.showError("Failed to load!");
                return;
            }
            byte[] data = (byte[])pair.getKey();
            AudioFormat format = (AudioFormat)pair.getValue();
            this.statusBar = "Reticulating splines...";
            byte[] preEncodeOutput = AudioResampler.toSigned8(data, format.getSampleSizeInBits(), format.getChannels(), format.isBigEndian(), format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED, (int)format.getSampleRate(), this.sampleRate, true);
            this.statusBar = "Encoding...";
            byte[] finalOutput = new byte[preEncodeOutput.length + 7 >> 3];
            CODEC.compress(finalOutput, preEncodeOutput, 0, 0, finalOutput.length);
            for (int i = 0; i < finalOutput.length; i += 8192) {
                int len = Math.min(finalOutput.length - i, 8192);
                byte[] dataEnc = new byte[len];
                System.arraycopy(finalOutput, i, dataEnc, 0, len);
                this.statusBar = "Uploading (" + i * 100 / finalOutput.length + "%)...";
                CharsetAudioStorage.packet.sendToServer((Packet)new PacketDriveData(dataEnc, finalOutput.length, i + len >= finalOutput.length));
            }
            this.statusBar = "Uploading (100%)...";
            Thread.sleep(250L);
            this.statusBar = "Uploaded!";
            Thread.sleep(1250L);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.statusBar = "Strange error!";
            try {
                Thread.sleep(1250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

