/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import java.io.IOException;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.Display;
import pl.asie.charset.lib.inventory.ContainerBase;
import pl.asie.charset.lib.inventory.GuiContainerCharset;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.module.audio.storage.AudioRecordThread;
import pl.asie.charset.module.audio.storage.CharsetAudioStorage;
import pl.asie.charset.module.audio.storage.ContainerRecordPlayer;
import pl.asie.charset.module.audio.storage.ItemQuartzDisc;
import pl.asie.charset.module.audio.storage.PacketDriveState;
import pl.asie.charset.module.audio.storage.TileRecordPlayer;
import pl.asie.charset.module.audio.storage.TraitRecordPlayer;

public class GuiRecordPlayer
extends GuiContainerCharset<ContainerRecordPlayer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("charset:textures/gui/recordplayergui.png");
    private static final int BUTTON_START_X = 88 - Button.values().length * 10;
    private static final int BUTTON_START_Y = 58;
    private TraitRecordPlayer.State state = TraitRecordPlayer.State.STOPPED;
    private TileRecordPlayer owner;
    private Button buttonHovering = null;
    private DialogThread fileDialog;
    private AudioRecordThread record;
    private Thread recordThread;
    private Thread fileDialogThread;

    public boolean isRecordingFromFile(boolean inProgress) {
        if (!inProgress && this.fileDialogThread != null && this.fileDialogThread.isAlive()) {
            return true;
        }
        return this.recordThread != null && this.recordThread.isAlive();
    }

    public GuiRecordPlayer(ContainerRecordPlayer container) {
        super((ContainerBase)container, 176, 166);
        this.owner = container.owner;
    }

    public boolean isButtonPressed(Button button) {
        if (button == this.buttonHovering) {
            return true;
        }
        if (this.isRecordingFromFile(false) && button == Button.RECORD_FILE) {
            return true;
        }
        switch (this.state) {
            case PLAYING: {
                return button == Button.PLAY;
            }
            case RECORDING: {
                return button == Button.RECORD_AUDIO;
            }
            case PAUSED: {
                return button == Button.PAUSE;
            }
        }
        return false;
    }

    public void setState(TraitRecordPlayer.State state) {
        if (this.owner != null) {
            try {
                PacketDriveState packet = new PacketDriveState(this.owner, state);
                CharsetAudioStorage.packet.sendToServer((Packet)packet);
                this.owner.setState(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleButtonPress(Button button) {
        if (this.isRecordingFromFile(false)) {
            return;
        }
        switch (button) {
            case PLAY: {
                this.setState(TraitRecordPlayer.State.PLAYING);
                break;
            }
            case PAUSE: {
                this.setState(TraitRecordPlayer.State.PAUSED);
                break;
            }
            case STOP: {
                this.setState(TraitRecordPlayer.State.STOPPED);
                break;
            }
            case RECORD_FILE: {
                if (this.owner.getStack() == null) break;
                if (this.owner.getState() == TraitRecordPlayer.State.PLAYING || this.owner.getState() == TraitRecordPlayer.State.RECORDING) {
                    this.setState(TraitRecordPlayer.State.PAUSED);
                }
                if (Minecraft.func_71410_x().func_71372_G()) {
                    Minecraft.func_71410_x().func_71352_k();
                }
                this.fileDialog = new DialogThread();
                this.fileDialogThread = new Thread(this.fileDialog);
                this.fileDialogThread.start();
                break;
            }
            case RECORD_AUDIO: {
                this.setState(TraitRecordPlayer.State.RECORDING);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.state = this.owner.getState();
        if (this.fileDialogThread != null && !this.fileDialogThread.isAlive()) {
            if (this.fileDialog.result == 0 && this.fileDialog.chooser.getSelectedFile() != null) {
                int rate = this.owner.getSampleRate();
                this.record = new AudioRecordThread(this.fileDialog.chooser.getSelectedFile(), rate, CharsetAudioStorage.quartzDisc.getSize(this.owner.getStack()));
                this.recordThread = new Thread(this.record);
                this.recordThread.start();
            }
            this.fileDialogThread = null;
            this.fileDialog = null;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.isRecordingFromFile(false) && (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i())) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73864_a(int x, int y, int mb) throws IOException {
        if (this.isRecordingFromFile(false)) {
            return;
        }
        super.func_73864_a(x, y, mb);
        if (mb == 0) {
            for (Button button : Button.values()) {
                int button_x = this.xBase + BUTTON_START_X + button.ordinal() * 20;
                int button_y = this.yBase + 58;
                if (x < button_x || x >= button_x + 20 || y < button_y || y >= button_y + 15 || this.isButtonPressed(button)) continue;
                this.buttonHovering = button;
                return;
            }
        }
    }

    public void func_146286_b(int x, int y, int which) {
        if (this.isRecordingFromFile(false)) {
            return;
        }
        super.func_146286_b(x, y, which);
        if (which >= 0 && this.buttonHovering != null) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.handleButtonPress(this.buttonHovering);
            this.buttonHovering = null;
        }
    }

    private String getLabel() {
        ItemStack stack = (ItemStack)this.field_147002_h.func_75138_a().get(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemQuartzDisc) {
            String label = I18n.func_74838_a((String)"tooltip.charset.disc.unnamed");
            if (stack.func_82837_s()) {
                label = stack.func_82833_r();
            }
            return label;
        }
        return null;
    }

    protected void func_146976_a(float f, int i, int j) {
        super.func_146976_a(f, i, j);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.xBase, this.yBase, 0, 0, this.field_146999_f, this.field_147000_g);
        for (Button button : Button.values()) {
            int button_ty = 166 + button.ordinal() * 15;
            int button_tx = this.isButtonPressed(button) ? 20 : 0;
            int button_x = BUTTON_START_X + button.ordinal() * 20;
            this.func_73729_b(this.xBase + button_x, this.yBase + 58, button_tx, button_ty, 20, 15);
        }
        GlStateManager.func_179147_l();
        this.func_73729_b(this.xBase + 98, this.yBase + 34, 98, 34, 22, 16);
        GlStateManager.func_179084_k();
        String label = this.getLabel();
        int labelColor = 0xFFFFFF;
        if (this.isRecordingFromFile(true)) {
            label = this.record.getStatusBar();
            labelColor = 9494704;
        } else {
            int width;
            if (label == null) {
                label = I18n.func_74838_a((String)"tooltip.charset.disc.none");
                labelColor = 0xFF3333;
            }
            if ((width = this.field_146289_q.func_78256_a(label)) > 142) {
                while (width > 136 && label.length() > 4) {
                    label = label.substring(0, label.length() - 1);
                    width = this.field_146289_q.func_78256_a(label);
                }
                label = label + "...";
            }
        }
        this.func_73732_a(this.field_146289_q, label, this.xBase + 88, this.yBase + 15, labelColor);
    }

    public static enum Button {
        PLAY,
        PAUSE,
        STOP,
        RECORD_FILE,
        RECORD_AUDIO;

    }

    public class DialogThread
    implements Runnable {
        public JFileChooser chooser = new JFileChooser();
        public int result;

        @Override
        public void run() {
            this.chooser.setFileSelectionMode(0);
            this.chooser.setDialogType(0);
            this.chooser.setFileFilter(new FileNameExtensionFilter("Audio file " + Arrays.toString(AudioRecordThread.getSupportedExtensions()), AudioRecordThread.getSupportedExtensions()));
            this.result = this.chooser.showOpenDialog(Display.getParent());
        }
    }
}

