/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.audio.AudioData;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioDataPCM;
import pl.asie.charset.api.audio.IAudioReceiver;
import pl.asie.charset.api.audio.IAudioSource;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.lib.audio.AudioUtils;
import pl.asie.charset.lib.audio.codec.DFPWM;
import pl.asie.charset.lib.audio.types.AudioDataDFPWM;
import pl.asie.charset.lib.audio.types.AudioSinkBlock;
import pl.asie.charset.lib.block.Trait;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.module.audio.storage.AudioResampler;
import pl.asie.charset.module.audio.storage.CharsetAudioStorage;
import pl.asie.charset.module.audio.storage.PacketDriveState;
import pl.asie.charset.module.audio.storage.TileRecordPlayer;

public class TraitRecordPlayer
extends Trait
implements IAudioSource,
IAudioReceiver {
    private final IItemHandler inventory;
    private State state = State.STOPPED;
    private State lastState;
    private Integer sourceId;
    private DFPWM recordDFPWM;
    private List<AudioPacket> receivedPacket = new ArrayList<AudioPacket>();
    protected double speedIn;

    public double getSpeed() {
        if (ModCharset.isModuleLoaded((String)"power.mechanical")) {
            return Math.min(this.speedIn, 9.0);
        }
        return 3.0;
    }

    public TraitRecordPlayer(IItemHandler handler) {
        this.inventory = handler;
    }

    public boolean exposesCapability(EnumFacing facing) {
        return true;
    }

    public void setState(State state) {
        this.lastState = this.state;
        this.state = state;
        if (state != State.RECORDING) {
            this.receivedPacket.clear();
            this.recordDFPWM = null;
        }
    }

    private void applyNoise(World world, byte[] data, float noiseThreshold) {
        Random rand = world.field_73012_v;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!(rand.nextFloat() <= noiseThreshold)) continue;
                int n = i;
                data[n] = (byte)(data[n] ^ 1 << j);
            }
        }
    }

    public int getSampleRate() {
        int s = (int)Math.round(48000.0 * this.getSpeed() / 480.0);
        return s * 160;
    }

    public void stopAudioPlayback() {
        if (this.sourceId != null) {
            AudioUtils.stop((int)this.sourceId);
            this.sourceId = null;
        }
    }

    public void update(World world, BlockPos blockPos) {
        if (this.state != State.STOPPED && this.state != State.PAUSED && this.getSpeed() >= 0.01) {
            IDataStorage storage;
            if (this.sourceId == null) {
                this.sourceId = AudioUtils.start();
            }
            boolean found = false;
            ItemStack stack = this.inventory.getStackInSlot(0);
            if (!stack.func_190926_b() && stack.hasCapability(CharsetAudioStorage.DATA_STORAGE, null) && (storage = (IDataStorage)stack.getCapability(CharsetAudioStorage.DATA_STORAGE, null)) != null) {
                found = true;
                if (this.state == State.PLAYING) {
                    int sampleRate = this.getSampleRate();
                    byte[] data = new byte[sampleRate / 160];
                    int len = storage.read(data, false);
                    if (world.func_175727_C(blockPos.func_177984_a())) {
                        this.applyNoise(world, data, 0.008f);
                    }
                    AudioPacket packet = new AudioPacket((AudioData)new AudioDataDFPWM(data, 50).setSourceId(this.sourceId.intValue()), 1.0f);
                    boolean received = false;
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        TileEntity tile = world.func_175625_s(blockPos.func_177972_a(facing));
                        if (tile == null || !tile.hasCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())) continue;
                        received |= ((IAudioReceiver)tile.getCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())).receive(packet);
                    }
                    if (!received) {
                        new AudioSinkBlock(world, blockPos).receive(packet);
                    }
                    packet.send();
                    if (len < data.length) {
                        this.setState(State.PAUSED);
                    }
                } else if (this.state == State.RECORDING) {
                    int sampleRate = this.getSampleRate();
                    if (!this.receivedPacket.isEmpty()) {
                        int adLen = 0;
                        for (AudioPacket packet : this.receivedPacket) {
                            adLen = Math.max(adLen, packet.getData().getTime() * sampleRate / 1000);
                        }
                        boolean added = false;
                        byte[] audioData = new byte[adLen];
                        for (AudioPacket packet : this.receivedPacket) {
                            int i;
                            byte[] preEncodeOutput;
                            AudioData data = packet.getData();
                            if (!(data instanceof IAudioDataPCM) || !(packet.getVolume() >= 0.01f)) continue;
                            IAudioDataPCM pcm = (IAudioDataPCM)data;
                            int len = audioData.length * 50 / data.getTime();
                            if (len <= 0 || (preEncodeOutput = AudioResampler.toSigned8(pcm.getSamplePCMData(), pcm.getSampleSize() * 8, 1, pcm.isSampleBigEndian(), pcm.isSampleSigned(), pcm.getSampleRate(), sampleRate, false)) == null) continue;
                            added = true;
                            if (packet.getVolume() >= 0.995f) {
                                for (i = 0; i < Math.min(preEncodeOutput.length, audioData.length); ++i) {
                                    int n = i;
                                    audioData[n] = (byte)(audioData[n] + preEncodeOutput[i]);
                                }
                                continue;
                            }
                            for (i = 0; i < Math.min(preEncodeOutput.length, audioData.length); ++i) {
                                int n = i;
                                audioData[n] = (byte)(audioData[n] + (byte)Math.round((float)preEncodeOutput[i] * packet.getVolume()));
                            }
                        }
                        if (added) {
                            if (this.recordDFPWM == null) {
                                this.recordDFPWM = new DFPWM();
                            }
                            byte[] dataOut = new byte[audioData.length / 8];
                            this.recordDFPWM.compress(dataOut, audioData, 0, 0, audioData.length / 8);
                            storage.write(dataOut);
                        }
                    }
                }
            }
            if (!found) {
                this.setState(State.STOPPED);
            }
        }
        if (this.lastState != this.state) {
            TileEntity tileEntity = world.func_175625_s(blockPos);
            CharsetAudioStorage.packet.sendToWatching((Packet)new PacketDriveState((TileRecordPlayer)tileEntity, this.state), tileEntity);
            if ((this.state == State.STOPPED || this.state == State.PAUSED) && this.lastState == State.PLAYING && this.sourceId != null) {
                this.stopAudioPlayback();
            }
        }
        this.lastState = this.state;
        this.receivedPacket.clear();
    }

    public void readNBTData(NBTTagCompound nbt, boolean isClient) {
        byte stateId;
        if (nbt.func_150297_b("st", 99) && (stateId = nbt.func_74771_c("st")) >= 0 && stateId < State.values().length) {
            this.state = State.values()[stateId];
        }
    }

    public NBTTagCompound writeNBTData(boolean isClient) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("st", (byte)this.state.ordinal());
        return compound;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return (capability == Capabilities.AUDIO_RECEIVER || capability == Capabilities.AUDIO_SOURCE) && this.exposesCapability(facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == Capabilities.AUDIO_SOURCE) {
            return (T)Capabilities.AUDIO_SOURCE.cast((Object)this);
        }
        if (capability == Capabilities.AUDIO_RECEIVER) {
            return (T)Capabilities.AUDIO_RECEIVER.cast((Object)this);
        }
        return null;
    }

    public State getState() {
        return this.state;
    }

    public IDataStorage getStorage() {
        IDataStorage storage;
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!stack.func_190926_b() && stack.hasCapability(CharsetAudioStorage.DATA_STORAGE, null) && (storage = (IDataStorage)stack.getCapability(CharsetAudioStorage.DATA_STORAGE, null)) != null) {
            return storage;
        }
        return null;
    }

    public boolean receive(AudioPacket packet) {
        if (this.state == State.RECORDING) {
            if (packet.getData() instanceof IAudioDataPCM && !this.receivedPacket.contains(packet)) {
                this.receivedPacket.add(packet);
            }
            return true;
        }
        return false;
    }

    public static enum State {
        STOPPED,
        PLAYING,
        RECORDING,
        PAUSED;

    }
}

