/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.audio.storage.compat.opencomputers;

import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.lib.modcompat.opencomputers.TraitOCEnvironment;
import pl.asie.charset.module.audio.storage.TileRecordPlayer;
import pl.asie.charset.module.audio.storage.TraitRecordPlayer;

public class TraitRecordPlayerOC
extends TraitOCEnvironment {
    public TraitRecordPlayerOC(TileEntity tile) {
        super(tile, Visibility.Network, "record_player");
    }

    TileRecordPlayer getTile() {
        return (TileRecordPlayer)this.tile;
    }

    ItemStack getStack() {
        return this.getTile().getStack();
    }

    IDataStorage getStorage() {
        return this.getTile().getStorage();
    }

    boolean hasReadyStorage() {
        return this.getStorage() != null && this.getStorage().isInitialized();
    }

    int getSampleRate() {
        return 48000;
    }

    int getBytesPerSecond() {
        return this.getSampleRate() / 8;
    }

    public void onConnect(Node node) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
    }

    @Callback(doc="function():boolean -- Returns true if there is a record in the player", direct=true)
    public Object[] isReady(Context context, Arguments args) {
        return new Object[]{this.hasReadyStorage()};
    }

    @Callback(doc="function():number -- Returns the record player's position, in seconds. Negative values indicate a resting arm.", direct=true)
    public Object[] getPosition(Context context, Arguments args) {
        return new Object[]{this.hasReadyStorage() ? (double)this.getStorage().getPosition() / (double)this.getBytesPerSecond() : -1.0};
    }

    @Callback(doc="function():number -- Returns the duration of the record, in seconds.", direct=true)
    public Object[] getDuration(Context context, Arguments args) {
        return new Object[]{this.hasReadyStorage() ? (double)this.getStorage().getSize() / (double)this.getBytesPerSecond() : 0.0};
    }

    @Callback(doc="function():number -- Returns the current sampling rate of the record player.", direct=true)
    public Object[] getSampleRate(Context context, Arguments args) {
        return new Object[]{this.getSampleRate()};
    }

    @Callback(doc="function():string -- Returns the name of the inserted record, if any.", direct=true)
    public Object[] getName(Context context, Arguments args) {
        ItemStack stack = this.getStack();
        return new Object[]{stack.func_190926_b() ? "" : (stack.func_82837_s() ? stack.func_82833_r() : "")};
    }

    @Callback(doc="function(duration:number):number -- Seeks the specified amount of seconds on the record. Negative values for rewinding. Returns the number of seconds sought.")
    public Object[] seek(Context context, Arguments args) {
        if (this.hasReadyStorage()) {
            int seekAmount = (int)Math.round(args.checkDouble(0) * (double)this.getBytesPerSecond());
            if (seekAmount == 0) {
                return new Object[]{0.0};
            }
            IDataStorage storage = this.getStorage();
            int oldPos = storage.getPosition();
            int newPos = oldPos + seekAmount;
            if (newPos < 0) {
                newPos = 0;
            } else if (newPos > storage.getSize()) {
                newPos = storage.getSize();
            }
            storage.setPosition(newPos);
            return new Object[]{(double)(newPos - oldPos) / (double)this.getBytesPerSecond()};
        }
        return new Object[]{0.0};
    }

    @Callback(doc="function():string -- Returns the current state of the player: \"playing\", \"paused\", \"stopped\" or \"recording\".", direct=true)
    public Object[] getState(Context context, Arguments args) {
        return new Object[]{this.getTile().getState().name().toLowerCase()};
    }

    @Callback(doc="function():boolean -- Sets the record player to play. Returns true if successful.")
    public Object[] play(Context context, Arguments args) {
        if (this.hasReadyStorage()) {
            this.getTile().setState(TraitRecordPlayer.State.PLAYING);
            return new Object[]{this.getTile().getState() == TraitRecordPlayer.State.PLAYING};
        }
        return new Object[]{false};
    }

    @Callback(doc="function():boolean -- Sets the record player to pause. Returns true if successful.")
    public Object[] pause(Context context, Arguments args) {
        if (this.hasReadyStorage()) {
            this.getTile().setState(TraitRecordPlayer.State.PAUSED);
            return new Object[]{this.getTile().getState() == TraitRecordPlayer.State.PAUSED};
        }
        return new Object[]{false};
    }

    @Callback(doc="function():boolean -- Sets the record player to record from external devices. Returns true if successful.")
    public Object[] record(Context context, Arguments args) {
        if (this.hasReadyStorage()) {
            this.getTile().setState(TraitRecordPlayer.State.RECORDING);
            return new Object[]{this.getTile().getState() == TraitRecordPlayer.State.RECORDING};
        }
        return new Object[]{false};
    }

    @Callback(doc="function():boolean -- Sets the record player to stop. Returns true if successful.")
    public Object[] stop(Context context, Arguments args) {
        this.getTile().setState(TraitRecordPlayer.State.STOPPED);
        return new Object[]{this.getTile().getState() == TraitRecordPlayer.State.STOPPED};
    }
}

