/*
 * Decompiled with CFR 0.152.
 */
package openmods.include;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openmods.Log;
import openmods.asm.StopTransforming;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class IncludingClassVisitor
extends ClassVisitor {
    public static final Type INCLUDE_INTERFACE = Type.getObjectType((String)"openmods/include/IncludeInterface");
    public static final Type INCLUDE_OVERRIDE = Type.getObjectType((String)"openmods/include/IncludeOverride");
    private final Set<Method> existingMethods = Sets.newHashSet();
    private final Set<Method> overrides = Sets.newHashSet();
    private final Map<Method, MethodAdder> methodsToAdd = Maps.newHashMap();
    private String clsName;
    private int version;
    private int access;
    private String signature;
    private String superName;
    private final Set<String> interfaces = Sets.newHashSet();

    public IncludingClassVisitor(ClassVisitor cv) {
        super(327680, cv);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor parent = super.visitField(access, name, desc, signature, value);
        return new AnnotatedFieldFinder(name, Type.getType((String)desc), parent);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Method method = new Method(name, desc);
        this.existingMethods.add(method);
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return new AnnotatedMethodFinder(method, parent);
    }

    public void visitEnd() {
        Sets.SetView conflicts = Sets.intersection(this.existingMethods, this.methodsToAdd.keySet());
        Sets.SetView nonMarked = Sets.difference((Set)conflicts, this.overrides);
        Preconditions.checkState((boolean)nonMarked.isEmpty(), (String)"%s implements interface methods %s, but they are not marked with @IncludeOverride", (Object)this.clsName, (Object)nonMarked);
        Sets.SetView markedButNotImplemented = Sets.difference(this.overrides, this.methodsToAdd.keySet());
        Preconditions.checkState((boolean)markedButNotImplemented.isEmpty(), (String)"%s marks methods %s with @IncludeOverride, but no interface implements it", (Object)this.clsName, (Object)markedButNotImplemented);
        Map filtered = Maps.filterKeys(this.methodsToAdd, arg_0 -> IncludingClassVisitor.lambda$visitEnd$0((Set)conflicts, arg_0));
        for (Map.Entry m : filtered.entrySet()) {
            ((MethodAdder)m.getValue()).addMethod(this.cv, (Method)m.getKey());
        }
        super.visit(this.version, this.access, this.clsName, this.signature, this.superName, this.interfaces.toArray(new String[this.interfaces.size()]));
        super.visitEnd();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (Modifier.isInterface(access)) {
            throw new StopTransforming();
        }
        this.clsName = name;
        this.access = access;
        this.version = version;
        this.signature = signature;
        this.superName = superName;
        this.interfaces.addAll(Arrays.asList(interfaces));
        super.visit(version, access, this.clsName, signature, superName, interfaces);
    }

    private List<Method> getInterfaceMethods(Type intf) {
        Preconditions.checkState((intf.getSort() == 10 ? 1 : 0) != 0, (String)"%s is not interface (including class = %s)", (Object)intf, (Object)this.clsName);
        try {
            Class<?> loaded = Class.forName(intf.getClassName());
            Preconditions.checkArgument((boolean)loaded.isInterface(), (String)"%s is not interface (including class = %s)", loaded, (Object)this.clsName);
            ArrayList result = Lists.newArrayList();
            for (java.lang.reflect.Method m : loaded.getMethods()) {
                result.add(Method.getMethod((java.lang.reflect.Method)m));
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            Log.severe(e, "Error while searching for interface '%s'", intf);
            throw new RuntimeException(e);
        }
    }

    private void addInterfaceImplementations(Type annotationHint, IIncludedMethodBuilder builder) {
        Type wrappedInterface = builder.getInterfaceType(annotationHint);
        boolean notYetDeclared = this.interfaces.add(wrappedInterface.getInternalName());
        Preconditions.checkState((boolean)notYetDeclared, (String)"%s already implements interface %s", (Object)this.clsName, (Object)wrappedInterface);
        Log.debug("Adding interface %s to %s", wrappedInterface.getInternalName(), this.clsName);
        for (Method m : this.getInterfaceMethods(wrappedInterface)) {
            MethodAdder prev = this.methodsToAdd.put(m, builder.createMethod(wrappedInterface));
            if (prev == null) continue;
            Preconditions.checkState((boolean)this.overrides.contains(m), (String)"Included method '%s' conflict, interfaces = %s,%s", (Object)m, (Object)wrappedInterface, (Object)prev.intf);
        }
    }

    private static /* synthetic */ boolean lambda$visitEnd$0(Set conflicts, Method m) {
        return !conflicts.contains(m);
    }

    private static abstract class MethodAdder {
        public final Type intf;

        private MethodAdder(Type intf) {
            this.intf = intf;
        }

        public abstract void visitInterfaceAccess(MethodVisitor var1);

        public void addMethod(ClassVisitor target, Method method) {
            MethodVisitor mv = target.visitMethod(4097, method.getName(), method.getDescriptor(), null, null);
            mv.visitVarInsn(25, 0);
            this.visitInterfaceAccess(mv);
            mv.visitTypeInsn(192, this.intf.getInternalName());
            Type[] args = method.getArgumentTypes();
            for (int i = 0; i < args.length; ++i) {
                mv.visitVarInsn(args[i].getOpcode(21), i + 1);
            }
            mv.visitMethodInsn(185, this.intf.getInternalName(), method.getName(), method.getDescriptor(), true);
            Type returnType = method.getReturnType();
            mv.visitInsn(returnType.getOpcode(172));
            mv.visitMaxs(args.length + 1, args.length + 1);
            mv.visitEnd();
        }
    }

    private class IncludeAnnotationVisitor
    extends AnnotationVisitor {
        private Type classParam;
        private final IIncludedMethodBuilder builder;

        public IncludeAnnotationVisitor(AnnotationVisitor av, IIncludedMethodBuilder builder) {
            super(327680, av);
            this.builder = builder;
        }

        public void visit(String name, Object value) {
            if ("value".equals(name) && value instanceof Type) {
                this.classParam = (Type)value;
            }
            super.visit(name, value);
        }

        public void visitEnd() {
            IncludingClassVisitor.this.addInterfaceImplementations(this.classParam, this.builder);
        }
    }

    private static interface IIncludedMethodBuilder {
        public Type getInterfaceType(Type var1);

        public MethodAdder createMethod(Type var1);
    }

    private class AnnotatedMethodFinder
    extends MethodVisitor
    implements IIncludedMethodBuilder {
        private final Method method;

        public AnnotatedMethodFinder(Method method, MethodVisitor mv) {
            super(327680, mv);
            this.method = method;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            Type t = Type.getType((String)desc);
            if (INCLUDE_INTERFACE.equals((Object)t)) {
                return new IncludeAnnotationVisitor(av, this);
            }
            if (INCLUDE_OVERRIDE.equals((Object)t)) {
                IncludingClassVisitor.this.overrides.add(this.method);
            }
            return av;
        }

        @Override
        public Type getInterfaceType(Type annotationHint) {
            return (Type)MoreObjects.firstNonNull((Object)annotationHint, (Object)this.method.getReturnType());
        }

        @Override
        public MethodAdder createMethod(Type wrappedInterface) {
            return new MethodAdder(wrappedInterface){

                @Override
                public void visitInterfaceAccess(MethodVisitor target) {
                    target.visitMethodInsn(182, IncludingClassVisitor.this.clsName, AnnotatedMethodFinder.this.method.getName(), AnnotatedMethodFinder.this.method.getDescriptor(), false);
                }
            };
        }
    }

    private class AnnotatedFieldFinder
    extends FieldVisitor
    implements IIncludedMethodBuilder {
        public final String fieldName;
        public final Type fieldType;

        public AnnotatedFieldFinder(String fieldName, Type fieldType, FieldVisitor fv) {
            super(327680, fv);
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            Type t = Type.getType((String)desc);
            if (INCLUDE_INTERFACE.equals((Object)t)) {
                return new IncludeAnnotationVisitor(av, this);
            }
            return av;
        }

        @Override
        public Type getInterfaceType(Type annotationHint) {
            return (Type)MoreObjects.firstNonNull((Object)annotationHint, (Object)this.fieldType);
        }

        @Override
        public MethodAdder createMethod(Type wrappedInterface) {
            return new MethodAdder(wrappedInterface){

                @Override
                public void visitInterfaceAccess(MethodVisitor target) {
                    target.visitFieldInsn(180, IncludingClassVisitor.this.clsName, AnnotatedFieldFinder.this.fieldName, AnnotatedFieldFinder.this.fieldType.getDescriptor());
                }
            };
        }
    }
}

