/*
 * Decompiled with CFR 0.152.
 */
package openmods.proxy;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.IGuiHandler;
import openmods.LibConfig;
import openmods.OpenMods;
import openmods.block.BlockSelectionHandler;
import openmods.calc.CommandCalc;
import openmods.calc.CommandCalcFactory;
import openmods.calc.ICommandComponent;
import openmods.config.game.ICustomItemModelProvider;
import openmods.config.properties.CommandConfig;
import openmods.geometry.HitboxManager;
import openmods.geometry.IHitboxSupplier;
import openmods.gui.ClientGuiHandler;
import openmods.model.MappedModelLoader;
import openmods.model.ModelWithDependencies;
import openmods.model.MultiLayerModel;
import openmods.model.PerspectiveAwareModel;
import openmods.model.eval.EvalExpandModel;
import openmods.model.eval.EvalModel;
import openmods.model.itemstate.ItemStateModel;
import openmods.model.textureditem.TexturedItemModel;
import openmods.model.variant.VariantModel;
import openmods.proxy.IOpenModsProxy;
import openmods.renderer.CommandGlDebug;
import openmods.source.CommandSource;
import openmods.utils.CachedFactory;
import openmods.utils.SneakyThrower;
import openmods.utils.render.FramebufferBlitter;
import openmods.utils.render.RenderUtils;

public final class OpenClientProxy
implements IOpenModsProxy {
    private final HitboxManager hitboxManager = new HitboxManager();
    private static final CachedFactory<Class<? extends ICustomItemModelProvider>, ICustomItemModelProvider> customItemModelProviders = new CachedFactory<Class<? extends ICustomItemModelProvider>, ICustomItemModelProvider>(){

        @Override
        protected ICustomItemModelProvider create(Class<? extends ICustomItemModelProvider> key) {
            try {
                return key.newInstance();
            }
            catch (Exception e) {
                throw SneakyThrower.sneakyThrow(e);
            }
        }
    };

    @Override
    public EntityPlayer getThePlayer() {
        return FMLClientHandler.instance().getClient().field_71439_g;
    }

    @Override
    public boolean isClientPlayer(Entity player) {
        return player instanceof EntityPlayerSP;
    }

    @Override
    public long getTicks(World worldObj) {
        if (worldObj != null) {
            return worldObj.func_82737_E();
        }
        World cWorld = this.getClientWorld();
        if (cWorld != null) {
            return cWorld.func_82737_E();
        }
        return 0L;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public World getServerWorld(int id) {
        return DimensionManager.getWorld((int)id);
    }

    @Override
    public File getMinecraftDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public String getLogFileName() {
        return "ForgeModLoader-client-0.log";
    }

    @Override
    public Optional<String> getLanguage() {
        return Optional.fromNullable((Object)Minecraft.func_71410_x().field_71474_y.field_74363_ab);
    }

    @Override
    public IGuiHandler wrapHandler(IGuiHandler modSpecificHandler) {
        return new ClientGuiHandler(modSpecificHandler);
    }

    @Override
    public void preInit() {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandConfig("om_config_c", false));
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSource("om_source_c", false, OpenMods.instance.getCollector()));
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandGlDebug());
        if (LibConfig.enableCalculatorCommands) {
            ICommandComponent commandRoot = new CommandCalcFactory(new File(this.getMinecraftDir(), "scripts")).getRoot();
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "config", new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "eval", "="));
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "fun", new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "let", new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "execute", new String[0]));
        }
        RenderUtils.registerFogUpdater();
        MinecraftForge.EVENT_BUS.register((Object)new BlockSelectionHandler());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)MappedModelLoader.builder().put("with-dependencies", ModelWithDependencies.EMPTY).put("multi-layer", MultiLayerModel.EMPTY).put("variantmodel", VariantModel.EMPTY_MODEL).put("textureditem", TexturedItemModel.INSTANCE).put("stateitem", ItemStateModel.EMPTY).put("eval", EvalModel.EMPTY).put("eval-expand", EvalExpandModel.EMPTY).put("perspective-aware", PerspectiveAwareModel.EMPTY).build("openmods"));
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this.hitboxManager);
        FramebufferBlitter.setup();
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public void setNowPlayingTitle(String nowPlaying) {
        Minecraft.func_71410_x().field_71456_v.func_73833_a(nowPlaying);
    }

    @Override
    public EntityPlayer getPlayerFromHandler(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).field_147369_b;
        }
        if (handler instanceof NetHandlerPlayClient) {
            return this.getThePlayer();
        }
        return null;
    }

    @Override
    public void bindItemModelToItemMeta(Item item, int metadata, ResourceLocation model) {
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        mesher.func_178086_a(item, metadata, new ModelResourceLocation(model, "inventory"));
    }

    @Override
    public void registerCustomItemModel(Item item, int metadata, ResourceLocation resourceLocation) {
        ModelResourceLocation modelLoc = resourceLocation instanceof ModelResourceLocation ? (ModelResourceLocation)resourceLocation : new ModelResourceLocation(resourceLocation, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)modelLoc);
    }

    @Override
    public void runCustomItemModelProvider(ResourceLocation location, Item item, Class<? extends ICustomItemModelProvider> providerCls) {
        ICustomItemModelProvider provider = customItemModelProviders.getOrCreate(providerCls);
        provider.addCustomItemModels(item, location, (meta, modelLocation) -> OpenMods.proxy.registerCustomItemModel(item, meta, modelLocation));
    }

    @Override
    public IHitboxSupplier getHitboxes(ResourceLocation location) {
        return this.hitboxManager.get(location);
    }

    @Override
    public IAnimationStateMachine loadAsm(ResourceLocation location, ImmutableMap<String, ITimeValue> parameters) {
        return ModelLoaderRegistry.loadASM((ResourceLocation)location, parameters);
    }
}

