/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.network.PacketBuffer;
import openmods.structured.Command;
import openmods.structured.ICustomCreateData;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;
import openmods.structured.IStructureObserver;
import openmods.structured.StructuredData;

public class StructuredDataMaster<C extends IStructureContainer<E>, E extends IStructureElement>
extends StructuredData<C, E> {
    public static final int CONSISTENCY_CHECK_PERIOD = 10;
    private final Set<Integer> newContainers = Sets.newTreeSet();
    private final Set<Integer> deletedContainers = Sets.newTreeSet();
    private final Set<Integer> modifiedElements = Sets.newTreeSet();
    private byte checkCount;
    private int nextElementId;
    private int nextContainerId;
    private boolean fullUpdateNeeded;

    public StructuredDataMaster() {
    }

    public StructuredDataMaster(IStructureObserver<C, E> observer) {
        super(observer);
    }

    public synchronized void appendUpdateCommands(List<Command> commands) {
        if (this.fullUpdateNeeded) {
            this.createFullCommands(commands);
            this.fullUpdateNeeded = false;
        } else {
            this.createUpdateCommands(commands);
        }
        this.clearUpdates();
    }

    public synchronized void appendFullCommands(List<Command> commands) {
        this.createFullCommands(commands);
    }

    private void createFullCommands(List<Command> commands) {
        commands.add(Command.RESET_INST);
        if (!this.containers.isEmpty()) {
            this.appendContainersCreate(commands, this.containers.keySet());
            commands.add(this.createConsistencyCheck());
        }
    }

    private void createUpdateCommands(List<Command> commands) {
        boolean addCheck;
        byte by = this.checkCount;
        this.checkCount = (byte)(by + 1);
        boolean bl = addCheck = by % 10 == 0;
        if (!this.deletedContainers.isEmpty()) {
            addCheck = true;
            Command.Delete delete = new Command.Delete();
            delete.idList.addAll(this.deletedContainers);
            commands.add(delete);
            this.newContainers.removeAll(this.deletedContainers);
        }
        if (!this.newContainers.isEmpty()) {
            addCheck = true;
            Set<Integer> newElements = this.appendContainersCreate(commands, this.newContainers);
            this.modifiedElements.removeAll(newElements);
        }
        if (!this.modifiedElements.isEmpty()) {
            Command.UpdateSingle update = new Command.UpdateSingle();
            update.idList.addAll(this.modifiedElements);
            update.elementPayload = this.createElementPayload(this.modifiedElements);
            commands.add(update);
        }
        if (addCheck) {
            commands.add(this.createConsistencyCheck());
        }
    }

    private synchronized Set<Integer> appendContainersCreate(List<Command> commands, Set<Integer> containersToSend) {
        TreeSet newElements = Sets.newTreeSet();
        Command.Create create = new Command.Create();
        for (Integer containerId : containersToSend) {
            IStructureContainer container = (IStructureContainer)this.containers.get(containerId);
            NavigableSet containerContents = this.containerToElement.get((Object)containerId);
            newElements.addAll(containerContents);
            int firstContainerElement = (Integer)containerContents.first();
            create.containers.add(new Command.ContainerInfo(containerId, container.getType(), firstContainerElement));
        }
        create.containerPayload = this.createContainerPayload(containersToSend);
        create.elementPayload = this.createElementPayload(newElements);
        commands.add(create);
        return newElements;
    }

    private synchronized Command.ConsistencyCheck createConsistencyCheck() {
        Command.ConsistencyCheck check = new Command.ConsistencyCheck();
        NavigableSet containers = this.containerToElement.keySet();
        if (!containers.isEmpty()) {
            check.containerCount = containers.size();
            check.minContainerId = (Integer)containers.first();
            check.maxContainerId = (Integer)containers.last();
        }
        if (!this.elements.isEmpty()) {
            check.elementCount = this.elements.size();
            check.minElementId = (Integer)this.elements.firstKey();
            check.maxElementId = (Integer)this.elements.lastKey();
        }
        return check;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.observer.onStructureUpdate();
        this.fullUpdateNeeded = true;
        this.clearUpdates();
        this.checkCount = 0;
        this.nextElementId = 0;
        this.nextContainerId = 0;
    }

    private synchronized void clearUpdates() {
        this.newContainers.clear();
        this.deletedContainers.clear();
        this.modifiedElements.clear();
    }

    public boolean hasUpdates() {
        return this.fullUpdateNeeded || !this.newContainers.isEmpty() || !this.deletedContainers.isEmpty() || !this.modifiedElements.isEmpty();
    }

    public synchronized void markElementModified(int elementId) {
        IStructureElement element = (IStructureElement)this.elements.get(elementId);
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (String)"No element with id %s", (int)elementId);
        this.modifiedElements.add(elementId);
        int containerId = this.elementToContainer.get(elementId);
        Preconditions.checkState((containerId != -1 ? 1 : 0) != 0, (String)"Inconsistent state for element %s", (int)elementId);
        IStructureContainer container = (IStructureContainer)this.containers.get(containerId);
        Preconditions.checkState((container != null ? 1 : 0) != 0, (String)"Inconsistent state for element %s, container %s", (int)elementId, (int)containerId);
        this.observer.onContainerUpdated(containerId, container);
        this.observer.onElementUpdated(containerId, container, elementId, element);
        this.observer.onDataUpdate();
    }

    public synchronized int addContainer(C container) {
        int containerId = this.nextContainerId++;
        this.nextElementId = this.addContainer(containerId, container, this.nextElementId);
        this.newContainers.add(containerId);
        this.observer.onStructureUpdate();
        return containerId;
    }

    @Override
    public synchronized SortedSet<Integer> removeContainer(int containerId) {
        SortedSet<Integer> removedElements = super.removeContainer(containerId);
        boolean isNewContainer = this.newContainers.remove(containerId);
        if (!isNewContainer) {
            this.deletedContainers.add(containerId);
        }
        this.modifiedElements.removeAll(removedElements);
        this.observer.onStructureUpdate();
        return removedElements;
    }

    private PacketBuffer createContainerPayload(Set<Integer> containerIds) {
        try {
            PacketBuffer result = new PacketBuffer(Unpooled.buffer());
            for (Integer id : containerIds) {
                IStructureContainer c = (IStructureContainer)this.containers.get(id);
                if (!(c instanceof ICustomCreateData)) continue;
                ((ICustomCreateData)((Object)c)).writeCustomDataFromStream(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private PacketBuffer createElementPayload(Collection<Integer> ids) {
        try {
            PacketBuffer output = new PacketBuffer(Unpooled.buffer());
            for (Integer id : ids) {
                IStructureElement element = (IStructureElement)this.elements.get(id);
                element.writeToStream(output);
            }
            return output;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

