/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.apparatus;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.texture.TextureUtils;
import cofh.core.render.IModelRegister;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ReconfigurableHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.apparatus.ItemBlockApparatus;
import cofh.thermalexpansion.block.apparatus.TileApparatusBase;
import cofh.thermalexpansion.block.apparatus.TileBreaker;
import cofh.thermalexpansion.block.apparatus.TileCollector;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockApparatus
extends BlockTEBase
implements IModelRegister,
IWorldBlockTextureProvider {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static boolean[] enable = new boolean[Type.values().length];
    public static ItemStack apparatusBreaker;
    public static ItemStack apparatusCollector;
    public static ItemBlockApparatus itemBlock;

    public BlockApparatus() {
        super(Material.field_151573_f);
        this.func_149663_c("apparatus");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.BREAKER)));
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{VARIANT});
        builder.add(new IUnlistedProperty[]{ModelErrorStateProperty.ERROR_STATE});
        builder.add(new IUnlistedProperty[]{TEProps.TILE_APPARATUS});
        builder.add(new IUnlistedProperty[]{TEProps.BAKERY_WORLD});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            if (!enable[i]) continue;
            items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i)));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata >= Type.values().length) {
            return null;
        }
        switch (Type.byMetadata(metadata)) {
            case BREAKER: {
                return new TileBreaker();
            }
            case COLLECTOR: {
                return new TileCollector();
            }
        }
        return null;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileApparatusBase tile = (TileApparatusBase)world.func_175625_s(pos);
            tile.readAugmentsFromNBT(stack.func_77978_p());
            tile.updateAugmentStatus();
            tile.setEnergyStored(stack.func_77978_p().func_74762_e("Energy"));
            int facing = BlockHelper.determineXZPlaceFacing((EntityLivingBase)living);
            byte storedFacing = ReconfigurableHelper.getFacing((ItemStack)stack);
            byte[] sideCache = ReconfigurableHelper.getSideCache((ItemStack)stack, (byte[])tile.getDefaultSides());
            tile.sideCache[0] = sideCache[0];
            tile.sideCache[1] = sideCache[1];
            tile.sideCache[facing] = sideCache[storedFacing];
            tile.sideCache[BlockHelper.getLeftSide((int)facing)] = sideCache[BlockHelper.getLeftSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getRightSide((int)facing)] = sideCache[BlockHelper.getRightSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getOppositeSide((int)facing)] = sideCache[BlockHelper.getOppositeSide((int)storedFacing)];
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, ItemStack stack) {
        return side != EnumFacing.NORTH ? TETextures.APPARATUS_SIDE : TETextures.APPARATUS_FACE[stack.func_77960_j() % Type.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, IBlockState state, BlockRenderLayer layer, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileApparatusBase) {
            TileApparatusBase tile = (TileApparatusBase)tileEntity;
            return tile.getTexture(side.ordinal(), layer == BlockRenderLayer.SOLID ? 0 : 1);
        }
        return TextureUtils.getMissingSprite();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMap.Builder stateMap = new StateMap.Builder();
        stateMap.func_178442_a(new IProperty[]{VARIANT});
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMap.func_178441_a());
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "normal");
        for (Type type : Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)location);
        }
        ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)new CCBakeryModel());
    }

    public boolean preInit() {
        this.setRegistryName("apparatus");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockApparatus((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ThermalExpansion.proxy.addIModelRegister(this);
        TileApparatusBase.config();
        TileBreaker.initialize();
        TileCollector.initialize();
        return true;
    }

    public boolean initialize() {
        apparatusBreaker = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.BREAKER.getMetadata()));
        apparatusCollector = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.COLLECTOR.getMetadata()));
        this.addRecipes();
        return true;
    }

    private void addRecipes() {
    }

    public static enum Type implements IStringSerializable
    {
        BREAKER(0, "breaker"),
        COLLECTOR(1, "collector");

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final int light;

        private Type(int metadata, String name, int light) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
        }

        private Type(int metadata, String name) {
            this(metadata, name, 0);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

