/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.network.PacketBase;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.filter.ItemFilter;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiItemCollector;
import cofh.thermalexpansion.gui.client.device.GuiItemCollectorFilter;
import cofh.thermalexpansion.gui.container.device.ContainerItemCollector;
import cofh.thermalexpansion.gui.container.device.ContainerItemCollectorFilter;
import cofh.thermalexpansion.init.TETextures;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileItemCollector
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.ITEM_COLLECTOR.getMetadata();
    private static final int RADIUS = 5;
    private static final int TIME_CONSTANT = 16;
    private ItemFilter filter = new ItemFilter(9);
    private int outputTracker;
    private int offset;
    private boolean forcedCycle;

    public static void initialize() {
        TileItemCollector.SIDE_CONFIGS[TileItemCollector.TYPE] = new SideConfig();
        TileItemCollector.SIDE_CONFIGS[TileItemCollector.TYPE].numConfig = 2;
        TileItemCollector.SIDE_CONFIGS[TileItemCollector.TYPE].slotGroups = new int[][]{new int[0], {0, 1, 2, 3, 4, 5, 6, 7, 8}};
        TileItemCollector.SIDE_CONFIGS[TileItemCollector.TYPE].sideTypes = new int[]{0, 4};
        TileItemCollector.SIDE_CONFIGS[TileItemCollector.TYPE].defaultSides = new byte[]{0, 1, 0, 0, 0, 0};
        TileItemCollector.SLOT_CONFIGS[TileItemCollector.TYPE] = new SlotConfig();
        TileItemCollector.SLOT_CONFIGS[TileItemCollector.TYPE].allowInsertionSlot = new boolean[]{false, false, false, false, false, false, false, false, false};
        TileItemCollector.SLOT_CONFIGS[TileItemCollector.TYPE].allowExtractionSlot = new boolean[]{true, true, true, true, true, true, true, true, true};
        GameRegistry.registerTileEntity(TileItemCollector.class, (String)"thermalexpansion:device_item_collector");
        TileItemCollector.config();
    }

    public static void config() {
        String category = "Device.ItemCollector";
        BlockDevice.enable[TileItemCollector.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileItemCollector() {
        this.inventory = new ItemStack[9];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.offset = MathHelper.RANDOM.nextInt(16);
        this.hasAutoOutput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void onRedstoneUpdate() {
        boolean curActive = this.isActive;
        this.isActive = this.redstoneControlOrDisable();
        if (this.isActive && !curActive && !this.forcedCycle) {
            this.collectItems();
            this.offset = (int)(16L - this.field_145850_b.func_82737_E() % 16L);
            this.forcedCycle = true;
        }
        this.updateIfChanged(curActive);
    }

    public void func_73660_a() {
        if (!this.timeCheckOffset()) {
            return;
        }
        this.forcedCycle = false;
        this.transferOutput();
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.collectItems();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.updateIfChanged(curActive);
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % 16L == 0L;
    }

    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        block0: for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]])) continue;
            for (int j = this.inventory.length - 1; j >= 0; --j) {
                if (!this.transferItem(j, 64, EnumFacing.field_82609_l[side])) continue;
                this.outputTracker = side;
                continue block0;
            }
        }
    }

    protected void collectItems() {
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, -5, -5), this.field_174879_c.func_177982_a(6, 6, 6));
        List items = this.field_145850_b.func_175647_a(EntityItem.class, area, EntitySelectors.field_94557_a);
        block0: for (EntityItem item : items) {
            ItemStack groundStack;
            if (item.getEntityData().func_74767_n("PreventRemoteMovement") || !this.filter.matches(groundStack = item.func_92059_d())) continue;
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i].func_190926_b()) {
                    this.func_70299_a(i, groundStack.func_77946_l());
                    groundStack.func_190920_e(0);
                } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.inventory[i], (ItemStack)groundStack)) {
                    int fill = this.inventory[i].func_77976_d() - this.inventory[i].func_190916_E();
                    if (fill > groundStack.func_190916_E()) {
                        this.inventory[i].func_190917_f(groundStack.func_190916_E());
                    } else {
                        this.inventory[i].func_190920_e(this.inventory[i].func_77976_d());
                    }
                    groundStack.func_77979_a(fill);
                }
                if (!groundStack.func_190926_b()) continue;
                item.func_70106_y();
                continue block0;
            }
        }
    }

    public ItemFilter getFilter() {
        return this.filter;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiItemCollector(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerItemCollector(inventory, (TileEntity)this);
    }

    public Object getConfigGuiClient(InventoryPlayer inventory) {
        return new GuiItemCollectorFilter(inventory, (TileEntity)this);
    }

    public Object getConfigGuiServer(InventoryPlayer inventory) {
        return new ContainerItemCollectorFilter(inventory, (TileEntity)this);
    }

    public boolean hasConfigGui() {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74782_a("Filter", (NBTBase)this.filter.serializeNBT());
        return nbt;
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addByte(this.filter.getFlagByte());
        return payload;
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addByte(this.filter.getFlagByte());
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.filter.setFlagByte((int)payload.getByte());
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.filter.setFlagByte((int)payload.getByte());
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.filter.matches(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.isActive ? TETextures.PORTAL_UNDERLAY : TETextures.DEVICE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.DEVICE_ACTIVE[TYPE] : TETextures.DEVICE_FACE[TYPE]);
        }
        return TETextures.DEVICE_SIDE;
    }
}

