/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.BaublesHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCharger;
import cofh.thermalexpansion.gui.container.machine.ContainerCharger;
import cofh.thermalexpansion.item.ItemCapacitor;
import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import cofh.thermalfoundation.init.TFFluids;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileCharger
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.CHARGER.getMetadata();
    private static final int[] ENERGY_TRANSFER = new int[]{1, 4, 9, 16, 25};
    public static int basePower = 40;
    public static int repairEnergy = 500;
    public static int repairFluid = 5;
    public static int wirelessRange = 32;
    private int inputTracker;
    private int outputTracker;
    private IEnergyContainerItem containerItem = null;
    private boolean hasContainerItem = false;
    private IEnergyStorage handler = null;
    private boolean hasEnergyHandler = false;
    private boolean hasRepairItem = false;
    private FluidTankCore tank = new FluidTankCore(4000);
    private List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    protected boolean augmentThroughput;
    protected boolean augmentRepair;
    protected boolean augmentWireless;
    protected boolean flagRepair;
    protected boolean flagWireless;

    public static void initialize() {
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE] = new SideConfig();
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE].numConfig = 5;
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE].slotGroups = new int[][]{new int[0], {0}, {2}, {0, 2}, {0, 2}};
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileCharger.SIDE_CONFIGS[TileCharger.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileCharger.ALT_SIDE_CONFIGS[TileCharger.TYPE] = new SideConfig();
        TileCharger.ALT_SIDE_CONFIGS[TileCharger.TYPE].numConfig = 2;
        TileCharger.ALT_SIDE_CONFIGS[TileCharger.TYPE].slotGroups = new int[][]{new int[0], {0}, {2}, {0, 2}, {0, 2}};
        TileCharger.ALT_SIDE_CONFIGS[TileCharger.TYPE].sideTypes = new int[]{0, 7};
        TileCharger.ALT_SIDE_CONFIGS[TileCharger.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileCharger.SLOT_CONFIGS[TileCharger.TYPE] = new SlotConfig();
        TileCharger.SLOT_CONFIGS[TileCharger.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false};
        TileCharger.SLOT_CONFIGS[TileCharger.TYPE].allowExtractionSlot = new boolean[]{false, false, true, false};
        TileCharger.VALID_AUGMENTS[TileCharger.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineChargerThroughput");
        VALID_AUGMENTS[TYPE].add("machineChargerRepair");
        VALID_AUGMENTS[TYPE].add("machineChargerWireless");
        TileCharger.LIGHT_VALUES[TileCharger.TYPE] = 7;
        int i = 0;
        while (i < ENERGY_TRANSFER.length) {
            int n = i++;
            ENERGY_TRANSFER[n] = ENERGY_TRANSFER[n] * 2000;
        }
        GameRegistry.registerTileEntity(TileCharger.class, (String)"thermalexpansion:machine_charger");
        TileCharger.config();
    }

    public static void config() {
        String category = "Machine.Charger";
        BlockMachine.enable[TileCharger.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for an Energetic Infuser. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileCharger.ENERGY_CONFIGS[TileCharger.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
        comment = "Adjust this value to change the amount of RF per point of durability in the Energetic Infuser with the Flux Reconstruction augment.";
        repairEnergy = ThermalExpansion.CONFIG.getConfiguration().getInt("RepairEnergy", category, repairEnergy, 100, 10000, comment);
        comment = "Adjust this value to change the amount of Essence of Knowledge per point of durability in the Energetic Infuser with the Flux Reconstruction augment.";
        repairFluid = ThermalExpansion.CONFIG.getConfiguration().getInt("RepairFluid", category, repairFluid, 1, 1000, comment);
        comment = "Adjust this value to change the wireless range for the Energetic Infuser with the Parabolic Flux Coupling augment.";
        wirelessRange = ThermalExpansion.CONFIG.getConfiguration().getInt("WirelessRange", category, wirelessRange, 8, 128, comment);
        wirelessRange *= wirelessRange;
    }

    public TileCharger() {
        this.inventory = new ItemStack[4];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(TFFluids.fluidExperience);
    }

    public int getType() {
        return TYPE;
    }

    private void updateContainerItem() {
        boolean curActive = this.isActive;
        if (this.augmentWireless || this.augmentRepair) {
            this.transferContainerItem();
            this.processOff();
        } else if (this.isActive) {
            this.processTickContainerItem();
            if (this.canFinishContainerItem()) {
                this.transferContainerItem();
                this.transferOutput();
                this.transferInput();
                if (!this.redstoneControlOrDisable() || !this.canStartContainerItem()) {
                    this.processOff();
                } else {
                    this.processTickContainerItem();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStartContainerItem()) {
                this.processTickContainerItem();
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    private boolean canStartContainerItem() {
        if (!EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1]) || this.augmentRepair || this.augmentWireless) {
            this.containerItem = null;
            this.hasContainerItem = false;
            return false;
        }
        return true;
    }

    private boolean canFinishContainerItem() {
        return this.containerItem.getEnergyStored(this.inventory[1]) >= this.containerItem.getMaxEnergyStored(this.inventory[1]) || this.augmentRepair || this.augmentWireless;
    }

    private int processTickContainerItem() {
        int energy = this.containerItem.receiveEnergy(this.inventory[1], this.calcEnergyItem(), false);
        this.energyStorage.modifyEnergyStored(-energy);
        return energy;
    }

    private void updateHandler() {
        boolean curActive = this.isActive;
        if (this.augmentWireless || this.augmentRepair) {
            this.transferHandler();
            this.processOff();
        } else if (this.isActive) {
            this.processTickHandler();
            if (this.canFinishHandler()) {
                this.transferHandler();
                this.transferOutput();
                this.transferInput();
                if (!this.redstoneControlOrDisable() || !this.canStartHandler()) {
                    this.processOff();
                } else {
                    this.processTickHandler();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStartHandler()) {
                this.processTickHandler();
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    private boolean canStartHandler() {
        if (!EnergyHelper.isEnergyHandler((ItemStack)this.inventory[1]) || this.augmentRepair || this.augmentWireless) {
            this.handler = null;
            this.hasEnergyHandler = false;
            return false;
        }
        return true;
    }

    private boolean canFinishHandler() {
        return this.handler.canReceive() && this.handler.getEnergyStored() >= this.handler.getMaxEnergyStored() || this.augmentRepair || this.augmentWireless;
    }

    private int processTickHandler() {
        int energy = this.handler.receiveEnergy(this.calcEnergyItem(), false);
        this.energyStorage.modifyEnergyStored(-energy);
        return energy;
    }

    public void updateRepairItem() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTickRepairItem();
            if (this.canFinishRepairItem()) {
                this.transferRepairItem();
                this.transferOutput();
                this.transferInput();
                this.energyStorage.modifyEnergyStored(this.processRem);
                this.processRem = 0;
                if (!this.redstoneControlOrDisable() || !this.canStartRepairItem()) {
                    this.processOff();
                } else {
                    this.processTickRepairItem();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStartRepairItem()) {
                this.processTickRepairItem();
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    private boolean canStartRepairItem() {
        if (!this.inventory[1].func_77984_f() || !this.augmentRepair) {
            this.hasRepairItem = false;
            return false;
        }
        return true;
    }

    private boolean canFinishRepairItem() {
        return this.inventory[1].func_77952_i() <= 0 || !this.augmentRepair;
    }

    private int processTickRepairItem() {
        if (this.inventory[1].func_77952_i() <= 0) {
            return 0;
        }
        int energy = this.calcEnergyRepair();
        this.processRem += energy;
        if (this.processRem >= repairEnergy) {
            this.inventory[1].func_77964_b(this.inventory[1].func_77952_i() - 1);
            this.tank.modifyFluidStored(-repairFluid);
            this.processRem -= repairEnergy;
        }
        this.energyStorage.modifyEnergyStored(-energy);
        return energy;
    }

    public void updateWireless() {
        boolean curActive = this.isActive;
        if (this.timeCheckEighth()) {
            this.findPlayersInRange();
        }
        if (this.isActive) {
            this.processTickWireless();
            if (!this.redstoneControlOrDisable() || this.calcEnergyWireless() <= 0) {
                this.processOff();
            }
        } else if (this.redstoneControlOrDisable() && this.timeCheckEighth() && this.calcEnergyWireless() > 0) {
            this.processTickWireless();
            this.isActive = true;
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    private void findPlayersInRange() {
        this.players.clear();
        Vec3d posCenter = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
        for (EntityPlayer player : this.field_145850_b.field_73010_i) {
            if (!(player.func_174791_d().func_72436_e(posCenter) < (double)wirelessRange)) continue;
            this.players.add(player);
        }
    }

    private int processTickWireless() {
        int energy = 0;
        for (EntityPlayer player : this.players) {
            energy += this.chargeInventoryItem(player.field_71071_by, false);
        }
        return energy;
    }

    private int chargeInventoryItem(InventoryPlayer inventory, boolean simulate) {
        Iterable equipment = Iterables.concat(Arrays.asList(BaublesHelper.getBaubles((Entity)inventory.field_70458_d), inventory.field_70462_a));
        for (ItemStack stack : equipment) {
            int energy;
            if (this.energyStorage.getEnergyStored() <= 0) {
                return 0;
            }
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCapacitor) || (energy = ((IEnergyContainerItem)stack.func_77973_b()).receiveEnergy(stack, Math.min(this.energyStorage.getEnergyStored(), this.getEnergyTransfer(this.level) / 2), simulate)) <= 0) continue;
            if (!simulate) {
                this.energyStorage.modifyEnergyStored(-energy);
            }
            return energy;
        }
        return 0;
    }

    @Override
    public void func_73660_a() {
        if (this.hasContainerItem) {
            this.updateContainerItem();
        } else if (this.hasEnergyHandler) {
            this.updateHandler();
        } else if (this.hasRepairItem) {
            this.updateRepairItem();
        } else if (this.augmentWireless) {
            this.updateWireless();
        } else {
            super.func_73660_a();
        }
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        ChargerManager.ChargerRecipe recipe;
        if (!this.inventory[1].func_190926_b()) {
            if (this.energyStorage.getEnergyStored() <= 0 || this.hasContainerItem || this.hasEnergyHandler) {
                return false;
            }
            if (!this.augmentWireless) {
                ChargerManager.ChargerRecipe recipe2 = ChargerManager.getRecipe(this.inventory[1]);
                if (recipe2 == null) {
                    return false;
                }
                if (this.inventory[1].func_190916_E() < recipe2.getInput().func_190916_E()) {
                    return false;
                }
                ItemStack output = recipe2.getOutput();
                return this.inventory[2].func_190926_b() || this.inventory[2].func_77969_a(output) && this.inventory[2].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
            }
        }
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (!this.augmentWireless && !this.augmentRepair) {
            if (!this.hasContainerItem && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
                this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
                this.inventory[0].func_190918_g(1);
                if (this.inventory[0].func_190916_E() <= 0) {
                    this.inventory[0] = ItemStack.field_190927_a;
                }
                this.containerItem = (IEnergyContainerItem)this.inventory[1].func_77973_b();
                this.hasContainerItem = true;
                return false;
            }
            if (!this.hasEnergyHandler && EnergyHelper.isEnergyHandler((ItemStack)this.inventory[0])) {
                this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
                this.inventory[0].func_190918_g(1);
                if (this.inventory[0].func_190916_E() <= 0) {
                    this.inventory[0] = ItemStack.field_190927_a;
                }
                this.handler = (IEnergyStorage)this.inventory[1].getCapability(CapabilityEnergy.ENERGY, null);
                this.hasEnergyHandler = true;
                return false;
            }
        } else if (!this.augmentWireless) {
            if (!this.hasRepairItem && this.inventory[0].func_77984_f()) {
                this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
                this.inventory[0].func_190918_g(1);
                if (this.inventory[0].func_190916_E() <= 0) {
                    this.inventory[0] = ItemStack.field_190927_a;
                }
                this.processRem = 0;
                this.hasRepairItem = true;
                return false;
            }
        } else {
            return true;
        }
        if ((recipe = ChargerManager.getRecipe(this.inventory[0])) == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < recipe.getInput().func_190916_E()) {
            return false;
        }
        ItemStack output = recipe.getOutput();
        return this.inventory[2].func_190926_b() || this.inventory[2].func_77969_a(output) && this.inventory[2].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.augmentWireless) {
            return true;
        }
        if (this.hasContainerItem || this.hasEnergyHandler || this.augmentRepair && this.hasRepairItem) {
            return true;
        }
        ChargerManager.ChargerRecipe recipe = ChargerManager.getRecipe(this.inventory[1]);
        return recipe != null && recipe.getInput().func_190916_E() <= this.inventory[1].func_190916_E();
    }

    @Override
    protected void processStart() {
        if (!this.inventory[1].func_190926_b()) {
            ChargerManager.ChargerRecipe recipe = ChargerManager.getRecipe(this.inventory[1]);
            this.processRem = this.processMax = recipe.getEnergy() * this.energyMod / 100;
        } else {
            ChargerManager.ChargerRecipe recipe = ChargerManager.getRecipe(this.inventory[0]);
            this.processRem = this.processMax = recipe.getEnergy() * this.energyMod / 100;
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)recipe.getInput().func_190916_E());
            this.inventory[0].func_190918_g(recipe.getInput().func_190916_E());
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
        }
    }

    @Override
    protected void processFinish() {
        ChargerManager.ChargerRecipe recipe = ChargerManager.getRecipe(this.inventory[1]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        ItemStack output = recipe.getOutput();
        if (this.inventory[2].func_190926_b()) {
            this.inventory[2] = ItemHelper.cloneStack((ItemStack)output);
        } else {
            this.inventory[2].func_190917_f(output.func_190916_E());
        }
        this.inventory[1] = ItemStack.field_190927_a;
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.inventory[2].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    private void transferContainerItem() {
        if (this.hasContainerItem) {
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)this.inventory[1], (int)1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.containerItem = null;
                this.hasContainerItem = false;
            } else if (ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)this.inventory[2]) && this.inventory[1].func_77976_d() > 1 && this.inventory[2].func_190916_E() + 1 <= this.inventory[2].func_77976_d()) {
                this.inventory[2].func_190917_f(1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.containerItem = null;
                this.hasContainerItem = false;
            }
        }
        if (!this.hasContainerItem && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0]) && !this.augmentRepair) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
            this.containerItem = (IEnergyContainerItem)this.inventory[1].func_77973_b();
            this.hasContainerItem = true;
        }
    }

    private void transferHandler() {
        if (this.hasEnergyHandler) {
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)this.inventory[1], (int)1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.handler = null;
                this.hasEnergyHandler = false;
            } else if (ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)this.inventory[2]) && this.inventory[1].func_77976_d() > 1 && this.inventory[2].func_190916_E() + 1 <= this.inventory[2].func_77976_d()) {
                this.inventory[2].func_190917_f(1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.handler = null;
                this.hasEnergyHandler = false;
            }
        }
        if (!this.hasEnergyHandler && EnergyHelper.isEnergyHandler((ItemStack)this.inventory[0]) && !this.augmentRepair) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
            this.handler = (IEnergyStorage)this.inventory[1].getCapability(CapabilityEnergy.ENERGY, null);
            this.hasEnergyHandler = true;
        }
    }

    private void transferRepairItem() {
        if (this.hasRepairItem) {
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)this.inventory[1], (int)1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.hasRepairItem = false;
            } else if (ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)this.inventory[2]) && this.inventory[1].func_77976_d() > 1 && this.inventory[2].func_190916_E() + 1 <= this.inventory[2].func_77976_d()) {
                this.inventory[2].func_190917_f(1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.hasRepairItem = false;
            }
        }
        if (!this.hasRepairItem && this.inventory[0].func_77984_f() && this.augmentRepair) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
            this.hasRepairItem = true;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCharger(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCharger(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentRepair() {
        return this.augmentRepair && this.flagRepair;
    }

    public boolean augmentWireless() {
        return this.augmentWireless && this.flagWireless;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        if (this.augmentRepair && this.inventory[1].func_77984_f()) {
            this.hasRepairItem = true;
        } else if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1])) {
            this.containerItem = (IEnergyContainerItem)this.inventory[1].func_77973_b();
            this.hasContainerItem = true;
        } else if (EnergyHelper.isEnergyHandler((ItemStack)this.inventory[1])) {
            this.handler = (IEnergyStorage)this.inventory[1].getCapability(CapabilityEnergy.ENERGY, null);
            this.hasEnergyHandler = true;
        } else if (this.inventory[1].func_77984_f()) {
            this.hasRepairItem = true;
        }
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentThroughput);
        payload.addBool(this.augmentRepair);
        payload.addBool(this.augmentWireless);
        payload.addBool(this.hasContainerItem);
        payload.addBool(this.hasEnergyHandler);
        payload.addBool(this.hasRepairItem);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.augmentThroughput = payload.getBool();
        this.augmentRepair = payload.getBool();
        this.augmentWireless = payload.getBool();
        this.flagRepair = this.augmentRepair;
        this.flagWireless = this.augmentWireless;
        this.hasContainerItem = payload.getBool();
        this.hasEnergyHandler = payload.getBool();
        this.hasRepairItem = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentThroughput = false;
        this.augmentRepair = false;
        this.augmentWireless = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (this.augmentThroughput) {
            this.energyStorage.setMaxTransfer(this.getEnergyTransfer(this.level) * 4);
        }
        if (!this.augmentRepair) {
            this.tank.drain(this.tank.getCapacity(), true);
        }
        if (this.augmentWireless) {
            if (this.processRem > 0) {
                this.processOff();
            }
            this.energyStorage.setMaxTransfer(this.getEnergyTransfer(this.level) * 2);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentThroughput && "machineChargerThroughput".equals(id)) {
            this.augmentThroughput = true;
            this.hasModeAugment = true;
            return true;
        }
        if (!this.augmentRepair && "machineChargerRepair".equals(id)) {
            this.augmentRepair = true;
            this.hasModeAugment = true;
            this.tank.setLock(TFFluids.fluidExperience);
            return true;
        }
        if (!this.augmentWireless && "machineChargerWireless".equals(id)) {
            this.augmentWireless = true;
            this.hasModeAugment = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    private int calcEnergyItem() {
        if (!this.augmentThroughput) {
            return this.calcEnergy();
        }
        return Math.min(this.energyStorage.getEnergyStored(), this.getEnergyTransfer(this.level));
    }

    private int calcEnergyRepair() {
        if (this.tank.getFluidAmount() < repairFluid) {
            return 0;
        }
        return Math.max(this.calcEnergy(), repairEnergy);
    }

    private int calcEnergyWireless() {
        if (this.energyStorage.getEnergyStored() <= 0) {
            return 0;
        }
        int energy = 0;
        for (EntityPlayer player : this.players) {
            energy += this.chargeInventoryItem(player.field_71071_by, true);
        }
        return energy;
    }

    private int getEnergyTransfer(int level) {
        return ENERGY_TRANSFER[MathHelper.clamp((int)level, (int)0, (int)4)];
    }

    @Override
    public int getInfoEnergyPerTick() {
        if (!this.isActive) {
            return 0;
        }
        if (this.augmentWireless) {
            return this.getEnergyTransfer(this.level) / 2;
        }
        if ((EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1]) || EnergyHelper.isEnergyHandler((ItemStack)this.inventory[1])) && this.augmentThroughput) {
            return this.getEnergyTransfer(this.level);
        }
        return this.calcEnergy();
    }

    @Override
    public int getInfoMaxEnergyPerTick() {
        if (this.augmentWireless) {
            return this.getEnergyTransfer(this.level) / 2;
        }
        if ((EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[1]) || EnergyHelper.isEnergyHandler((ItemStack)this.inventory[1])) && this.augmentThroughput) {
            return this.getEnergyTransfer(this.level);
        }
        return this.energyConfig.maxPower;
    }

    @Override
    public int updateAccelerable() {
        if (this.hasContainerItem) {
            return this.processTickContainerItem();
        }
        if (this.hasEnergyHandler) {
            return this.processTickHandler();
        }
        if (this.hasRepairItem) {
            return this.processTickRepairItem();
        }
        if (this.augmentWireless) {
            return this.processTickWireless();
        }
        return this.processTick();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot == 1 && this.isActive && (this.inventory[slot].func_190926_b() || !this.hasValidInput())) {
            this.processOff();
            this.containerItem = null;
            this.hasContainerItem = false;
            this.handler = null;
            this.hasEnergyHandler = false;
            this.hasRepairItem = false;
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot == 1) {
            if (!(!this.isActive || this.inventory[slot].func_190926_b() || !stack.func_190926_b() && stack.func_77969_a(this.inventory[slot]) && this.hasValidInput())) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_145850_b);
                this.processRem = 0;
            }
            this.containerItem = null;
            this.hasContainerItem = false;
            this.handler = null;
            this.hasEnergyHandler = false;
            this.hasRepairItem = false;
        }
        this.inventory[slot] = stack;
        this.markChunkDirty();
    }

    @Override
    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.containerItem = null;
            this.hasContainerItem = false;
            this.handler = null;
            this.hasEnergyHandler = false;
            this.hasRepairItem = false;
        }
        super.func_70296_d();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.augmentWireless) {
            return false;
        }
        if (this.augmentRepair) {
            return slot != 0 || stack.func_77984_f() || ChargerManager.recipeExists(stack);
        }
        if (slot != 0) {
            return true;
        }
        if (EnergyHelper.isEnergyContainerItem((ItemStack)stack)) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)stack.func_77973_b();
            return containerItem.getEnergyStored(stack) < containerItem.getMaxEnergyStored(stack);
        }
        if (EnergyHelper.isEnergyHandler((ItemStack)stack)) {
            IEnergyStorage containerItem = EnergyHelper.getEnergyHandler((ItemStack)stack);
            return containerItem.getEnergyStored() < containerItem.getMaxEnergyStored();
        }
        return ChargerManager.recipeExists(stack);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentRepair && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentRepair && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileCharger.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return TileCharger.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileCharger.this.isActive) {
                        return null;
                    }
                    if (from == null || SideConfig.allowExtraction((int)((TileCharger)TileCharger.this).sideConfig.sideTypes[TileCharger.this.sideCache[from.ordinal()]])) {
                        return TileCharger.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileCharger.this.isActive) {
                        return null;
                    }
                    if (from == null || SideConfig.allowExtraction((int)((TileCharger)TileCharger.this).sideConfig.sideTypes[TileCharger.this.sideCache[from.ordinal()]])) {
                        return TileCharger.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

