/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.IBakery;
import cofh.core.init.CoreEnchantments;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.storage.ItemBlockTank;
import cofh.thermalexpansion.block.storage.TileTank;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.render.BakeryTank;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalfoundation.item.ItemUpgrade;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockTank
extends BlockTEBase
implements IModelRegister,
IBakeryProvider {
    public static boolean enable = true;
    public static boolean enableCreative = true;
    public static boolean enableSecurity = true;
    public static boolean enableClassicRecipes = false;
    public static boolean enableUpgradeKitCrafting = false;
    public static ItemStack[] tank;
    public static ItemStack tankCreative;
    public static ItemBlockTank itemBlock;

    public BlockTank() {
        super(Material.field_151592_s);
        this.func_149663_c("tank");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b());
        this.standardGui = false;
        this.configGui = true;
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IUnlistedProperty[]{ModelErrorStateProperty.ERROR_STATE});
        builder.add(new IUnlistedProperty[]{TEProps.TILE_TANK});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable) {
            if (TEProps.creativeTabShowAllBlockLevels) {
                for (int j = 0; j <= 4; ++j) {
                    items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this), j));
                }
            } else {
                items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this), TEProps.creativeTabLevel));
            }
            if (TEProps.creativeTabShowCreative) {
                items.add((Object)itemBlock.setCreativeTag(new ItemStack((Block)this)));
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileTank();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileTank tile = (TileTank)world.func_175625_s(pos);
            tile.isCreative = stack.func_77978_p().func_74767_n("Creative");
            tile.enchantHolding = (byte)EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            if (stack.func_77978_p().func_74764_b("Fluid")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
                tile.getTank().setFluid(fluid);
                tile.setLocked(stack.func_77978_p().func_74767_n("Lock"));
            }
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP || side == EnumFacing.DOWN;
    }

    @Override
    public boolean onBlockActivatedDelegate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileTank tile = (TileTank)world.func_175625_s(pos);
        if (tile == null || !tile.canPlayerAccess(player)) {
            return false;
        }
        if (ItemHelper.isPlayerHoldingNothing((EntityPlayer)player) && player.func_70093_af()) {
            tile.setLocked(!tile.isLocked());
            if (tile.isLocked()) {
                world.func_184133_a(null, pos, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.2f, 0.8f);
            } else {
                world.func_184133_a(null, pos, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.5f);
            }
            return true;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (FluidHelper.isFluidHandler((ItemStack)heldItem)) {
            FluidHelper.interactWithHandler((ItemStack)heldItem, (IFluidHandler)handler, (EntityPlayer)player, (EnumHand)hand);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        NBTTagCompound retTag = super.getItemStackTag(world, pos);
        TileTank tile = (TileTank)world.func_175625_s(pos);
        if (tile != null) {
            FluidStack fluid;
            if (tile.enchantHolding > 0) {
                CoreEnchantments.addEnchantment((NBTTagCompound)retTag, (Enchantment)CoreEnchantments.holding, (int)tile.enchantHolding);
            }
            if ((fluid = tile.getTankFluid()) != null) {
                retTag.func_74782_a("Fluid", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
                retTag.func_74757_a("Lock", tile.isLocked());
            }
        }
        return retTag;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return BakeryTank.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper("thermalexpansion", "tank", "tank");
        ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)mapper.location);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mapper);
        ModelLoader.setCustomMeshDefinition((Item)itemBlock, (ItemMeshDefinition)mapper);
        ModelRegistryHelper.register((ModelResourceLocation)mapper.location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            StringBuilder builder = new StringBuilder(ModelBakery.defaultBlockKeyGenerator.generateKey(state));
            TileTank tank = (TileTank)((Object)((Object)state.getValue(TEProps.TILE_TANK)));
            builder.append(",creative=").append(tank.isCreative);
            builder.append(",level=").append(tank.getLevel());
            builder.append(",holding=").append(tank.enchantHolding);
            builder.append(",output=").append(tank.getTransferOut());
            builder.append(",lock=").append(tank.isLocked());
            FluidStack stack = tank.getTankFluid();
            if (stack != null) {
                builder.append(",fluid=").append(stack.hashCode());
            }
            return builder.toString();
        });
        ModelBakery.registerItemKeyGenerator((Item)itemBlock, stack -> {
            FluidStack fluid;
            String fluidAppend = "";
            if (stack.func_77978_p() != null && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"))) != null && fluid.amount > 0) {
                fluidAppend = ",fluid=" + fluid.getFluid().getName() + ",amount=" + fluid.amount;
            }
            return ModelBakery.defaultItemKeyGenerator.generateKey(stack) + ",creative=" + itemBlock.isCreative(stack) + ",level=" + itemBlock.getLevel(stack) + fluidAppend;
        });
    }

    public boolean preInit() {
        this.setRegistryName("tank");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockTank((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileTank.initialize();
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        tank = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            BlockTank.tank[i] = itemBlock.setDefaultTag(new ItemStack((Block)this), i);
        }
        tankCreative = itemBlock.setCreativeTag(new ItemStack((Block)this));
        this.addRecipes();
        this.addUpgradeRecipes();
        this.addClassicRecipes();
        return true;
    }

    private void addRecipes() {
        if (enable) {
            RecipeHelper.addShapedRecipe((ItemStack)tank[0], (Object[])new Object[]{" I ", "ICI", " P ", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "blockGlass", Character.valueOf('P'), ItemMaterial.redstoneServo});
        }
    }

    private void addUpgradeRecipes() {
        int j;
        if (!enableUpgradeKitCrafting || !enable) {
            return;
        }
        if (!enableClassicRecipes) {
            for (j = 0; j < 4; ++j) {
                RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)tank[j + 1], (Object[])new Object[]{tank[j], ItemUpgrade.upgradeIncremental[j]});
            }
            for (j = 1; j < 4; ++j) {
                for (int k = 0; k <= j; ++k) {
                    RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)tank[j + 1], (Object[])new Object[]{tank[k], ItemUpgrade.upgradeFull[j]});
                }
            }
        }
        for (j = 0; j < 5; ++j) {
            RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)tankCreative, (Object[])new Object[]{tank[j], ItemUpgrade.upgradeCreative});
        }
    }

    private void addClassicRecipes() {
        if (!enableClassicRecipes || !enable) {
            return;
        }
        RecipeHelper.addShapedRecipe((ItemStack)tank[1], (Object[])new Object[]{"YIY", "ICI", "YPY", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "blockGlass", Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('Y'), "ingotInvar"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)tank[1], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), tank[0], Character.valueOf('I'), "ingotInvar"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)tank[2], (Object[])new Object[]{"YIY", "ICI", "YIY", Character.valueOf('C'), tank[1], Character.valueOf('I'), "ingotElectrum", Character.valueOf('Y'), "blockGlassHardened"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)tank[3], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), tank[2], Character.valueOf('I'), "ingotSignalum"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)tank[4], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), tank[3], Character.valueOf('I'), "ingotEnderium"});
    }
}

