/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.transposer;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.machine.TileTransposer;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class TransposerRecipeWrapper
extends BaseRecipeWrapper {
    protected List<List<ItemStack>> inputs;
    protected List<FluidStack> inputFluids;
    protected List<ItemStack> outputs;
    protected List<FluidStack> outputFluids;
    protected int chance;
    protected IDrawableStatic progressBack;
    protected IDrawableAnimated fluid;
    protected IDrawableAnimated progress;
    protected IDrawableAnimated speed;

    public TransposerRecipeWrapper() {
    }

    public TransposerRecipeWrapper(IGuiHelper guiHelper, TransposerManager.TransposerRecipe recipe, String uIdIn) {
        IDrawableStatic progressDrawable;
        IDrawableStatic fluidDrawable;
        this.uId = uIdIn;
        ArrayList<ItemStack> recipeInputs = new ArrayList<ItemStack>();
        int oreID = TransposerManager.convertInput((ItemStack)recipe.getInput()).oreID;
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputs.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getInput().func_190916_E()));
            }
        } else {
            recipeInputs.add(recipe.getInput());
        }
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        recipeOutputs.add(recipe.getOutput());
        ArrayList<FluidStack> recipeFluids = new ArrayList<FluidStack>();
        recipeFluids.add(recipe.getFluid());
        this.inputs = Collections.singletonList(recipeInputs);
        this.outputs = recipeOutputs;
        if (this.uId.equals("thermalexpansion.transposer_fill")) {
            this.inputFluids = recipeFluids;
            this.outputFluids = Collections.emptyList();
        } else {
            this.inputFluids = Collections.emptyList();
            this.outputFluids = recipeFluids;
        }
        this.energy = recipe.getEnergy();
        this.chance = recipe.getChance();
        if (this.uId.equals("thermalexpansion.transposer_fill")) {
            this.progressBack = Drawables.getDrawables(guiHelper).getProgressLeft(2);
            fluidDrawable = Drawables.getDrawables(guiHelper).getProgressLeft(2);
            progressDrawable = Drawables.getDrawables(guiHelper).getProgressLeftFill(2);
            this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TileTransposer.basePower, IDrawableAnimated.StartDirection.RIGHT, true);
            this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileTransposer.basePower, IDrawableAnimated.StartDirection.RIGHT, false);
        } else {
            this.progressBack = Drawables.getDrawables(guiHelper).getProgress(2);
            fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(2);
            progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(2);
            this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TileTransposer.basePower, IDrawableAnimated.StartDirection.LEFT, true);
            this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileTransposer.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        }
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(1);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
        if (this.uId.equals("thermalexpansion.transposer_fill")) {
            ingredients.setInputs(FluidStack.class, this.inputFluids);
        } else {
            ingredients.setOutputs(FluidStack.class, this.outputFluids);
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.progressBack.draw(minecraft, 63, 11);
        if (this.uId.equals("thermalexpansion.transposer_fill")) {
            JEIPluginTE.drawFluid(63, 11, this.inputFluids.get(0), 24, 16);
        } else {
            JEIPluginTE.drawFluid(63, 11, this.outputFluids.get(0), 24, 16);
        }
        this.fluid.draw(minecraft, 63, 11);
        this.progress.draw(minecraft, 63, 11);
        this.speed.draw(minecraft, 68, 41);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

