/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import cofh.core.inventory.ComparableItemStack;
import com.google.common.collect.ImmutableSet;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class NumismaticManager {
    private static TObjectIntHashMap<ComparableItemStack> fuelMap = new TObjectIntHashMap();
    private static TObjectIntHashMap<ComparableItemStack> gemFuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 30000;

    public static Set<ComparableItemStack> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static Set<ComparableItemStack> getGemFuels() {
        return ImmutableSet.copyOf((Collection)gemFuelMap.keySet());
    }

    public static int getFuelEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return fuelMap.get((Object)new ComparableItemStack(stack));
    }

    public static int getGemFuelEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return gemFuelMap.get((Object)new ComparableItemStack(stack));
    }

    public static void refresh() {
        TObjectIntHashMap tempMap = new TObjectIntHashMap(fuelMap.size());
        TObjectIntHashMap tempMap2 = new TObjectIntHashMap(gemFuelMap.size());
        TObjectIntIterator it = fuelMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        it = gemFuelMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempMap2.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        fuelMap.clear();
        fuelMap = tempMap;
        gemFuelMap.clear();
        gemFuelMap = tempMap2;
    }

    public static boolean addFuel(ItemStack stack, int energy) {
        if (stack.func_190926_b() || energy < 1000 || energy > 200000000) {
            return false;
        }
        fuelMap.put((Object)new ComparableItemStack(stack), energy);
        return true;
    }

    public static boolean addGemFuel(ItemStack stack, int energy) {
        if (stack.func_190926_b() || energy < 1000 || energy > 200000000) {
            return false;
        }
        gemFuelMap.put((Object)new ComparableItemStack(stack), energy);
        return true;
    }

    public static boolean removeFuel(ItemStack stack) {
        fuelMap.remove((Object)new ComparableItemStack(stack));
        return true;
    }

    public static boolean removeGemFuel(ItemStack stack) {
        gemFuelMap.remove((Object)new ComparableItemStack(stack));
        return true;
    }
}

