/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidated;
import cofh.core.inventory.OreValidator;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.init.TFEquipment;
import cofh.thermalfoundation.item.ItemMaterial;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class PulverizerManager {
    private static Map<ComparableItemStackValidated, PulverizerRecipe> recipeMap = new Object2ObjectOpenHashMap();
    private static OreValidator oreValidator = new OreValidator();
    static final int ORE_MULTIPLIER = 2;
    public static final int DEFAULT_ENERGY = 4000;

    public static PulverizerRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidated query = PulverizerManager.convertInput(input);
        PulverizerRecipe recipe = recipeMap.get(query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get(query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return PulverizerManager.getRecipe(input) != null;
    }

    public static PulverizerRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new PulverizerRecipe[0]);
    }

    public static void initialize() {
        int energy = 3000;
        ItemStack output = ItemMaterial.dustWood;
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151041_m), output, 2);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151039_o), output, 2);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151053_p), output, 2);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151038_n), output, 2);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151017_I), output, 2);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.WOOD.toolBow, output, 2);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.WOOD.toolFishingRod, output, 2);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.WOOD.toolShears, output, 2);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.WOOD.toolSickle, output, 2);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.WOOD.toolHammer, output, 4);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.WOOD.toolShield, output, 6);
        energy = 6000;
        output = new ItemStack(Items.field_151045_i);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151048_u), output, 1);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151046_w), output, 1);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151056_x), output, 1);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151047_v), output, 1);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151012_L), output, 1);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151161_ac), output, 2);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151163_ad), output, 4);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151173_ae), output, 3);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151175_af), output, 2);
        PulverizerManager.addRecycleRecipe(energy, new ItemStack(Items.field_151125_bZ), output, 2);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolBow, output, 1);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolFishingRod, output, 1);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolShears, output, 1);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolSickle, output, 1);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolHammer, output, 2);
        PulverizerManager.addRecycleRecipe(energy, TFEquipment.ToolSetVanilla.DIAMOND.toolShield, output, 3);
        for (String oreName : OreDictionary.getOreNames()) {
            if (oreName.startsWith("ore") || oreName.startsWith("gem")) {
                String oreType = oreName.substring(3, oreName.length());
                PulverizerManager.addDefaultRecipes(oreType, "");
                continue;
            }
            if (!oreName.startsWith("dust")) continue;
            String oreType = oreName.substring(4, oreName.length());
            PulverizerManager.addDefaultRecipes(oreType, "");
        }
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackValidated, PulverizerRecipe> entry : recipeMap.entrySet()) {
            PulverizerRecipe tempRecipe = entry.getValue();
            tempMap.put(PulverizerManager.convertInput(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static PulverizerRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input.func_190926_b() || primaryOutput.func_190926_b() || energy <= 0 || PulverizerManager.recipeExists(input)) {
            return null;
        }
        PulverizerRecipe recipe = new PulverizerRecipe(input, primaryOutput, secondaryOutput, secondaryOutput.func_190926_b() ? 0 : secondaryChance, energy);
        recipeMap.put(PulverizerManager.convertInput(input), recipe);
        return recipe;
    }

    public static PulverizerRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return PulverizerManager.addRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static PulverizerRecipe addRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return PulverizerManager.addRecipe(energy, input, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static PulverizerRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove(PulverizerManager.convertInput(input));
    }

    public static ComparableItemStackValidated convertInput(ItemStack stack) {
        return new ComparableItemStackValidated(stack, oreValidator);
    }

    private static void addDefaultRecipes(String oreType, String relatedOre) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String suffix = StringHelper.titleCase((String)oreType);
        String oreName = "ore" + suffix;
        String gemName = "gem" + suffix;
        String dustName = "dust" + suffix;
        String ingotName = "ingot" + suffix;
        String oreNetherName = "oreNether" + suffix;
        String oreEndName = "oreEnd" + suffix;
        ItemStack ore = ItemHelper.getOre((String)oreName);
        ItemStack gem = ItemHelper.getOre((String)gemName);
        ItemStack dust = ItemHelper.getOre((String)dustName);
        ItemStack ingot = ItemHelper.getOre((String)ingotName);
        ItemStack oreNether = ItemHelper.getOre((String)oreNetherName);
        ItemStack oreEnd = ItemHelper.getOre((String)oreEndName);
        ItemStack related = relatedOre.isEmpty() ? ItemStack.field_190927_a : ItemHelper.getOre((String)relatedOre);
        int energy = 4000;
        if (!gem.func_190926_b()) {
            PulverizerManager.addRecipe(energy, ore, ItemHelper.cloneStack((ItemStack)gem, (int)2), related, related.func_190926_b() ? 0 : 10);
            PulverizerManager.addRecipe(energy, oreNether, ItemHelper.cloneStack((ItemStack)gem, (int)4), related, related.func_190926_b() ? 0 : 20);
            PulverizerManager.addRecipe(energy, oreEnd, ItemHelper.cloneStack((ItemStack)gem, (int)4), related, related.func_190926_b() ? 0 : 20);
            PulverizerManager.addRecipe(energy / 2, gem, ItemHelper.cloneStack((ItemStack)dust, (int)1));
        } else {
            PulverizerManager.addRecipe(energy, ore, ItemHelper.cloneStack((ItemStack)dust, (int)2), related, related.func_190926_b() ? 0 : 10);
            PulverizerManager.addRecipe(energy, oreNether, ItemHelper.cloneStack((ItemStack)dust, (int)4), related, related.func_190926_b() ? 0 : 20);
            PulverizerManager.addRecipe(energy, oreEnd, ItemHelper.cloneStack((ItemStack)dust, (int)4), related, related.func_190926_b() ? 0 : 20);
            PulverizerManager.addRecipe(energy / 2, ingot, ItemHelper.cloneStack((ItemStack)dust, (int)1));
        }
    }

    public static void addRecycleRecipe(int energy, ItemStack input, ItemStack output, int outputSize) {
        PulverizerManager.addRecycleRecipe(energy, input, output, outputSize, true);
    }

    public static void addRecycleRecipe(int energy, ItemStack input, ItemStack output, int outputSize, boolean wildcard) {
        ItemStack recycleInput = wildcard ? input.func_77946_l() : new ItemStack(input.func_77973_b(), 1, Short.MAX_VALUE);
        PulverizerManager.addRecipe(energy, recycleInput, ItemHelper.cloneStack((ItemStack)output, (int)outputSize));
    }

    public static boolean isOre(ItemStack stack) {
        return ItemHelper.isOre((ItemStack)stack) || ItemHelper.isCluster((ItemStack)stack);
    }

    static {
        oreValidator.addPrefix("ore");
        oreValidator.addPrefix("ingot");
        oreValidator.addPrefix("nugget");
        oreValidator.addPrefix("log");
        oreValidator.addPrefix("plank");
        oreValidator.addExact("sand");
        oreValidator.addExact("treeSapling");
        oreValidator.addExact("treeLeaves");
    }

    public static class PulverizerRecipe {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        PulverizerRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.input = input;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput;
        }

        public ItemStack getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

