/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.dynamo;

import cofh.thermalexpansion.util.managers.dynamo.NumismaticManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;

public class NumismaticParser
extends BaseParser {
    public static final String GEM = "gem";
    public static final String LAPIDARY = "lapidary";
    int defaultEnergy = NumismaticManager.DEFAULT_ENERGY;

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement contentElement : contentArray) {
            JsonObject content = contentElement.getAsJsonObject();
            if (content.has("//")) continue;
            int energy = this.defaultEnergy;
            ItemStack input = NumismaticParser.parseItemStack(content.get("input"));
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (content.has("type")) {
                String type = content.get("type").getAsString();
                if (GEM.equals(type) || LAPIDARY.equals(type)) {
                    if (NumismaticManager.addGemFuel(input, energy)) {
                        ++this.parseCount;
                        continue;
                    }
                    ++this.errorCount;
                    continue;
                }
                ++this.errorCount;
                continue;
            }
            if (NumismaticManager.addFuel(input, energy)) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }
}

