/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.machine;

import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleParser
extends BaseParser {
    int defaultEnergy = 8000;

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement recipe : contentArray) {
            JsonObject content = recipe.getAsJsonObject();
            if (content.has("//")) continue;
            int energy = this.defaultEnergy;
            ItemStack input = CrucibleParser.parseItemStack(content.get("input"));
            FluidStack output = CrucibleParser.parseFluidStack(content.get("output"));
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (CrucibleManager.addRecipe(energy, input, output) != null) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }
}

