/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.golems.client;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.IGolemProperties;
import thaumcraft.api.golems.parts.PartModel;
import thaumcraft.client.lib.obj.AdvancedModelLoader;
import thaumcraft.client.lib.obj.IModelCustom;
import thaumcraft.common.golems.EntityThaumcraftGolem;

@SideOnly(value=Side.CLIENT)
public class RenderThaumcraftGolem
extends RenderBiped {
    private static final Logger logger = LogManager.getLogger();
    private HashMap<String, IModelCustom> models = new HashMap();
    private HashMap<Integer, HashMap<PartModel.EnumAttachPoint, ArrayList<PartModel>>> partsCache = new HashMap();
    private IModelCustom baseModel;
    float swingProgress = 0.0f;

    public RenderThaumcraftGolem(RenderManager p_i46127_1_) {
        super(p_i46127_1_, new ModelBiped(), 0.3f);
        this.field_177097_h.clear();
        this.baseModel = AdvancedModelLoader.loadModel(new ResourceLocation("thaumcraft", "models/obj/golem_base.obj"));
    }

    private void renderModel(EntityThaumcraftGolem entity, float p1, float p2, float p3, float p4, float p5, float p6, float partialTicks) {
        boolean flag1;
        boolean flag = !entity.func_82150_aj();
        boolean bl = flag1 = !flag && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            if (flag1) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            }
            this.renderParts(entity, p1, p2, p3, p4, p5, p6, partialTicks);
            if (flag1) {
                GlStateManager.func_179084_k();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179132_a((boolean)true);
            }
        }
    }

    private void renderParts(EntityThaumcraftGolem entity, float limbSwing, float prevLimbSwing, float rotFloat, float headPitch, float headYaw, float p_78087_6_, float partialTicks) {
        PartModel part2;
        ResourceLocation matTexture = entity.getProperties().getMaterial().texture;
        boolean holding = !entity.func_184614_ca().func_190926_b();
        boolean aflag = entity.getProperties().hasTrait(EnumGolemTrait.WHEELED) || entity.getProperties().hasTrait(EnumGolemTrait.FLYER);
        Vec3d v1 = new Vec3d(entity.field_70165_t, 0.0, entity.field_70161_v);
        Vec3d v2 = new Vec3d(entity.field_70169_q, 0.0, entity.field_70166_s);
        double speed = v1.func_72436_e(v2);
        if (entity.redrawParts || !this.partsCache.containsKey(entity.func_145782_y())) {
            entity.redrawParts = false;
            this.createPartsCache(entity);
        }
        float f1 = 0.0f;
        float bry = 0.0f;
        float rx = (float)Math.toDegrees(MathHelper.func_76126_a((float)(rotFloat * 0.067f)) * 0.03f);
        float rz = (float)Math.toDegrees(MathHelper.func_76134_b((float)(rotFloat * 0.09f)) * 0.05f + 0.05f);
        float rrx = 0.0f;
        float rry = 0.0f;
        float rrz = 0.0f;
        float rlx = 0.0f;
        float rly = 0.0f;
        float rlz = 0.0f;
        if (holding) {
            rrx = 90.0f - rz / 2.0f;
            rrz = -2.0f;
            rlx = 90.0f - rz / 2.0f;
            rlz = 2.0f;
        } else {
            if (aflag) {
                rrx = rx * 2.0f;
                rlx = -rx * 2.0f;
            } else {
                f1 = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * prevLimbSwing * 0.5f;
                rrx = (float)(Math.toDegrees(f1) + (double)rx);
                f1 = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * prevLimbSwing * 0.5f;
                rlx = (float)(Math.toDegrees(f1) - (double)rx);
            }
            rrz += rz + 2.0f;
            rlz -= rz + 2.0f;
        }
        if (this.swingProgress > 0.0f) {
            float wiggle = -MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)this.swingProgress) * (float)Math.PI * 2.0f)) * 0.2f;
            bry = (float)Math.toDegrees(wiggle);
            rrz = -((float)Math.toDegrees(MathHelper.func_76126_a((float)wiggle) * 3.0f));
            rrx = (float)Math.toDegrees(-MathHelper.func_76134_b((float)wiggle) * 5.0f);
            rry += bry;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GlStateManager.func_179114_b((float)bry, (float)0.0f, (float)1.0f, (float)0.0f);
        float lean = 25.0f;
        if (aflag) {
            lean = 75.0f;
        }
        GlStateManager.func_179114_b((float)((float)(speed * (double)lean)), (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(speed * (double)lean * 0.06 * (double)(entity.field_70177_z - entity.field_70126_B))), (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
        this.func_110776_a(matTexture);
        this.baseModel.renderPart("chest");
        this.baseModel.renderPart("waist");
        if (entity.getGolemColor() > 0) {
            Color c = new Color(EnumDyeColor.func_176764_b((int)(entity.getGolemColor() - 1)).func_193350_e());
            GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
            this.baseModel.renderPart("flag");
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (PartModel part2 : this.partsCache.get(entity.func_145782_y()).get((Object)PartModel.EnumAttachPoint.BODY)) {
            this.renderPart(entity, part2.getObjModel().toString(), part2, matTexture, partialTicks, PartModel.EnumLimbSide.MIDDLE);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.75, (double)-0.03125);
        GlStateManager.func_179114_b((float)headPitch, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)headYaw, (float)-1.0f, (float)0.0f, (float)0.0f);
        for (PartModel part2 : this.partsCache.get(entity.func_145782_y()).get((Object)PartModel.EnumAttachPoint.HEAD)) {
            this.renderPart(entity, part2.getObjModel().toString(), part2, matTexture, partialTicks, PartModel.EnumLimbSide.MIDDLE);
        }
        this.func_110776_a(matTexture);
        this.baseModel.renderPart("head");
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.20625, (double)0.6875, (double)0.0);
        Iterator<PartModel> iterator = this.partsCache.get(entity.func_145782_y()).get((Object)PartModel.EnumAttachPoint.ARMS).iterator();
        if (iterator.hasNext()) {
            part2 = iterator.next();
            rrx = part2.preRenderArmRotationX(entity, partialTicks, PartModel.EnumLimbSide.RIGHT, rrx);
            rry = part2.preRenderArmRotationY(entity, partialTicks, PartModel.EnumLimbSide.RIGHT, rry);
            rrz = part2.preRenderArmRotationZ(entity, partialTicks, PartModel.EnumLimbSide.RIGHT, rrz);
        }
        GlStateManager.func_179114_b((float)rrx, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rry, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rrz, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_110776_a(matTexture);
        this.baseModel.renderPart("arm");
        for (PartModel part2 : this.partsCache.get(entity.func_145782_y()).get((Object)PartModel.EnumAttachPoint.ARMS)) {
            this.renderPart(entity, part2.getObjModel().toString(), part2, matTexture, partialTicks, PartModel.EnumLimbSide.RIGHT);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)-0.20625, (double)0.6875, (double)0.0);
        iterator = this.partsCache.get(entity.func_145782_y()).get((Object)PartModel.EnumAttachPoint.ARMS).iterator();
        if (iterator.hasNext()) {
            part2 = iterator.next();
            rlx = part2.preRenderArmRotationX(entity, partialTicks, PartModel.EnumLimbSide.LEFT, rlx);
            rly = part2.preRenderArmRotationY(entity, partialTicks, PartModel.EnumLimbSide.LEFT, rly);
            rlz = part2.preRenderArmRotationZ(entity, partialTicks, PartModel.EnumLimbSide.LEFT, rlz);
        }
        GlStateManager.func_179114_b((float)rlx, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rly + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rlz, (float)0.0f, (float)0.0f, (float)-1.0f);
        this.func_110776_a(matTexture);
        this.baseModel.renderPart("arm");
        for (PartModel part2 : this.partsCache.get(entity.func_145782_y()).get((Object)PartModel.EnumAttachPoint.ARMS)) {
            this.renderPart(entity, part2.getObjModel().toString(), part2, matTexture, partialTicks, PartModel.EnumLimbSide.LEFT);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.09375, (double)0.375, (double)0.0);
        f1 = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * prevLimbSwing;
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(f1)), (float)1.0f, (float)0.0f, (float)0.0f);
        for (PartModel part2 : this.partsCache.get(entity.func_145782_y()).get((Object)PartModel.EnumAttachPoint.LEGS)) {
            this.renderPart(entity, part2.getObjModel().toString(), part2, matTexture, partialTicks, PartModel.EnumLimbSide.RIGHT);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)-0.09375, (double)0.375, (double)0.0);
        f1 = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * prevLimbSwing;
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(f1)), (float)1.0f, (float)0.0f, (float)0.0f);
        for (PartModel part2 : this.partsCache.get(entity.func_145782_y()).get((Object)PartModel.EnumAttachPoint.LEGS)) {
            this.renderPart(entity, part2.getObjModel().toString(), part2, matTexture, partialTicks, PartModel.EnumLimbSide.LEFT);
        }
        GlStateManager.func_179121_F();
        GL11.glDisable((int)3042);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.625, (double)0.0);
        GlStateManager.func_179114_b((float)(90.0f - rz * 0.5f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.drawHeldItem(entity);
        GlStateManager.func_179121_F();
    }

    private void drawHeldItem(EntityThaumcraftGolem entity) {
        ItemStack itemstack = entity.func_184614_ca();
        if (itemstack != null && !itemstack.func_190926_b()) {
            GlStateManager.func_179094_E();
            Item item = itemstack.func_77973_b();
            Minecraft minecraft = Minecraft.func_71410_x();
            GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.375, (double)0.375, (double)0.375);
            GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)-1.5f);
            if (!(item instanceof ItemBlock)) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.6f, (float)0.0f);
            }
            minecraft.func_175597_ag().func_178099_a((EntityLivingBase)entity, itemstack, ItemCameraTransforms.TransformType.HEAD);
            GlStateManager.func_179121_F();
        }
    }

    private void renderPart(EntityThaumcraftGolem golem, String partName, PartModel part, ResourceLocation matTexture, float partialTicks, PartModel.EnumLimbSide side) {
        IModelCustom model = this.models.get(partName);
        if (model == null) {
            model = AdvancedModelLoader.loadModel(part.getObjModel());
            if (model != null) {
                this.models.put(partName, model);
            } else {
                return;
            }
        }
        for (String op : model.getPartNames()) {
            GL11.glPushMatrix();
            if (part.useMaterialTextureForObjectPart(op)) {
                this.func_110776_a(matTexture);
            } else {
                this.func_110776_a(part.getTexture());
            }
            part.preRenderObjectPart(op, golem, partialTicks, side);
            model.renderPart(op);
            part.postRenderObjectPart(op, golem, partialTicks, side);
            GL11.glPopMatrix();
        }
    }

    private void doRender(EntityThaumcraftGolem entity, double x, double y, double z, float p_76986_8_, float partialTicks) {
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((EntityLivingBase)entity, (RenderLivingBase)this, x, y, z))) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        this.swingProgress = this.func_77040_d((EntityLivingBase)entity, partialTicks);
        try {
            float f5;
            float f2 = this.func_77034_a(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
            float f3 = this.func_77034_a(entity.field_70758_at, entity.field_70759_as, partialTicks);
            float f4 = f3 - f2;
            if (entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase1 = (EntityLivingBase)entity.func_184187_bx();
                f2 = this.func_77034_a(entitylivingbase1.field_70760_ar, entitylivingbase1.field_70761_aq, partialTicks);
                f4 = f3 - f2;
                f5 = MathHelper.func_76142_g((float)f4);
                if (f5 < -85.0f) {
                    f5 = -85.0f;
                }
                if (f5 >= 85.0f) {
                    f5 = 85.0f;
                }
                f2 = f3 - f5;
                if (f5 * f5 > 2500.0f) {
                    f2 += f5 * 0.2f;
                }
            }
            float f9 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            this.func_77039_a((EntityLivingBase)entity, x, y, z);
            f5 = this.func_77044_a((EntityLivingBase)entity, partialTicks);
            this.func_77043_a((EntityLivingBase)entity, f5, f2, partialTicks);
            GlStateManager.func_179091_B();
            this.func_77041_b((EntityLivingBase)entity, partialTicks);
            float f7 = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialTicks;
            float f8 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
            if (f7 > 1.0f) {
                f7 = 1.0f;
            }
            GlStateManager.func_179141_d();
            if (this.field_188301_f) {
                boolean flag = this.func_177088_c((EntityLivingBase)entity);
                this.renderModel(entity, f8, f7, f5, f4, f9, 0.0625f, partialTicks);
                if (flag) {
                    this.func_180565_e();
                }
            } else {
                boolean flag = this.func_177090_c((EntityLivingBase)entity, partialTicks);
                this.renderModel(entity, f8, f7, f5, f4, f9, 0.0625f, partialTicks);
                if (flag) {
                    this.func_177091_f();
                }
                GlStateManager.func_179132_a((boolean)true);
                this.func_177093_a((EntityLivingBase)entity, f8, f7, partialTicks, f5, f4, f9, 0.0625f);
            }
            GlStateManager.func_179101_C();
        }
        catch (Exception exception) {
            logger.error("Couldn't render entity", (Throwable)exception);
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (!this.field_188301_f) {
            this.func_177067_a((EntityLivingBase)entity, x, y, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((EntityLivingBase)entity, (RenderLivingBase)this, x, y, z));
        this.func_110827_b((EntityLiving)entity, x, y, z, p_76986_8_, partialTicks);
    }

    private void createPartsCache(EntityThaumcraftGolem golem) {
        HashMap pl = new HashMap();
        pl.put(PartModel.EnumAttachPoint.BODY, new ArrayList());
        pl.put(PartModel.EnumAttachPoint.HEAD, new ArrayList());
        pl.put(PartModel.EnumAttachPoint.ARMS, new ArrayList());
        pl.put(PartModel.EnumAttachPoint.LEGS, new ArrayList());
        IGolemProperties props = golem.getProperties();
        if (props.getHead().model != null) {
            ((ArrayList)pl.get((Object)props.getHead().model.getAttachPoint())).add(props.getHead().model);
        }
        if (props.getArms().model != null) {
            ((ArrayList)pl.get((Object)props.getArms().model.getAttachPoint())).add(props.getArms().model);
        }
        if (props.getLegs().model != null) {
            ((ArrayList)pl.get((Object)props.getLegs().model.getAttachPoint())).add(props.getLegs().model);
        }
        if (props.getAddon().model != null) {
            ((ArrayList)pl.get((Object)props.getAddon().model.getAttachPoint())).add(props.getAddon().model);
        }
        this.partsCache.put(golem.func_145782_y(), pl);
    }

    public void func_76986_a(EntityLiving entity, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.doRender((EntityThaumcraftGolem)entity, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
    }

    protected ResourceLocation func_110775_a(EntityLiving p_110775_1_) {
        return null;
    }
}

