/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.tools;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.IThaumcraftItems;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemElementalAxe
extends ItemAxe
implements IThaumcraftItems {
    public ItemElementalAxe(Item.ToolMaterial enumtoolmaterial) {
        super(enumtoolmaterial, 8.0f, -3.0f);
        this.func_77637_a(ConfigItems.TABTC);
        this.setRegistryName("elemental_axe");
        this.func_77655_b("elemental_axe");
        ConfigItems.ITEM_VARIANT_HOLDERS.add(this);
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public String[] getVariantNames() {
        return new String[]{"normal"};
    }

    @Override
    public int[] getVariantMeta() {
        return new int[]{0};
    }

    @Override
    public ItemMeshDefinition getCustomMesh() {
        return null;
    }

    @Override
    public ModelResourceLocation getCustomModelResourceLocation(String variant) {
        return new ModelResourceLocation("thaumcraft:" + variant);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"axe");
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.RARE;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77969_a(new ItemStack(ItemsTC.ingots, 1, 0)) ? true : super.func_82789_a(stack1, stack2);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        List<EntityItem> stuff = EntityUtils.getEntitiesInRange(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, (Entity)player, EntityItem.class, 10.0);
        if (stuff != null && stuff.size() > 0) {
            for (EntityItem e : stuff) {
                if (e.field_70128_L) continue;
                double d6 = e.field_70165_t - player.field_70165_t;
                double d8 = e.field_70163_u - player.field_70163_u + (double)(player.field_70131_O / 2.0f);
                double d10 = e.field_70161_v - player.field_70161_v;
                double d11 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8 + d10 * d10));
                double d13 = 0.3;
                e.field_70159_w -= (d6 /= d11) * d13;
                e.field_70181_x -= (d8 /= d11) * d13 - 0.1;
                e.field_70179_y -= (d10 /= d11) * d13;
                if (e.field_70159_w > 0.25) {
                    e.field_70159_w = 0.25;
                }
                if (e.field_70159_w < -0.25) {
                    e.field_70159_w = -0.25;
                }
                if (e.field_70181_x > 0.25) {
                    e.field_70181_x = 0.25;
                }
                if (e.field_70181_x < -0.25) {
                    e.field_70181_x = -0.25;
                }
                if (e.field_70179_y > 0.25) {
                    e.field_70179_y = 0.25;
                }
                if (e.field_70179_y < -0.25) {
                    e.field_70179_y = -0.25;
                }
                if (!player.field_70170_p.field_72995_K) continue;
                FXDispatcher.INSTANCE.crucibleBubble((float)e.field_70165_t + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f, (float)e.field_70163_u + e.field_70131_O + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f, (float)e.field_70161_v + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f, 0.33f, 0.33f, 1.0f);
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == ConfigItems.TABTC) {
            ItemStack w1 = new ItemStack((Item)this);
            EnumInfusionEnchantment.addInfusionEnchantment(w1, EnumInfusionEnchantment.BURROWING, 1);
            EnumInfusionEnchantment.addInfusionEnchantment(w1, EnumInfusionEnchantment.COLLECTOR, 1);
            items.add((Object)w1);
        } else {
            super.func_150895_a(tab, items);
        }
    }
}

