/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.crafting;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.ThaumcraftInvHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.golems.IGolemProperties;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.golems.GolemProperties;
import thaumcraft.common.golems.ItemGolemPlacer;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TileThaumcraftInventory;

public class TileGolemBuilder
extends TileThaumcraftInventory
implements IEssentiaTransport {
    public long golem = -1L;
    public int cost = 0;
    public int maxCost = 0;
    public boolean[] hasStuff = null;
    boolean bufferedEssentia = false;
    int ticks = 0;
    public int press = 0;
    IGolemProperties props = null;
    ItemStack[] components = null;

    public TileGolemBuilder() {
        super(1);
        this.syncedSlots = new int[]{0};
    }

    @Override
    public void readSyncNBT(NBTTagCompound nbttagcompound) {
        this.syncedSlots = new int[]{0};
        super.readSyncNBT(nbttagcompound);
        this.golem = nbttagcompound.func_74763_f("golem");
        this.cost = nbttagcompound.func_74762_e("cost");
        this.maxCost = nbttagcompound.func_74762_e("mcost");
        if (this.golem >= 0L) {
            try {
                this.props = GolemProperties.fromLong(this.golem);
                this.components = this.props.generateComponents();
            }
            catch (Exception e) {
                this.props = null;
                this.components = null;
                this.cost = 0;
                this.golem = -1L;
            }
        }
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74772_a("golem", this.golem);
        nbttagcompound.func_74768_a("cost", this.cost);
        nbttagcompound.func_74768_a("mcost", this.maxCost);
        return super.writeSyncNBT(nbttagcompound);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean complete = false;
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticks;
            if (this.ticks % 5 == 0 && !complete && this.cost > 0 && this.golem >= 0L) {
                if (this.bufferedEssentia || this.drawEssentia()) {
                    this.bufferedEssentia = false;
                    --this.cost;
                    this.func_70296_d();
                }
                if (this.cost <= 0) {
                    ItemStack placer = new ItemStack(ItemsTC.golemPlacer);
                    placer.func_77983_a("props", (NBTBase)new NBTTagLong(this.golem));
                    if (this.func_70301_a(0).func_190926_b() || this.func_70301_a(0).func_190916_E() < this.func_70301_a(0).func_77976_d() && this.func_70301_a(0).func_77969_a(placer) && ItemStack.func_77970_a((ItemStack)this.func_70301_a(0), (ItemStack)placer)) {
                        if (this.func_70301_a(0) == null || this.func_70301_a(0).func_190926_b()) {
                            this.func_70299_a(0, placer.func_77946_l());
                        } else {
                            this.func_70301_a(0).func_190917_f(1);
                        }
                        complete = true;
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.wand, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        } else {
            int a;
            if (this.press < 90 && this.cost > 0 && this.golem > 0L) {
                this.press += 6;
                if (this.press >= 60) {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.66f, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, false);
                    for (a = 0; a < 16; ++a) {
                        FXDispatcher.INSTANCE.drawVentParticles((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, this.field_145850_b.field_73012_v.nextGaussian() * 0.1, 0.0, this.field_145850_b.field_73012_v.nextGaussian() * 0.1, 0xAAAAAA);
                    }
                }
            }
            if (this.press >= 90 && this.field_145850_b.field_73012_v.nextInt(8) == 0) {
                FXDispatcher.INSTANCE.drawVentParticles((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, this.field_145850_b.field_73012_v.nextGaussian() * 0.1, 0.0, this.field_145850_b.field_73012_v.nextGaussian() * 0.1, 0xAAAAAA);
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.1f, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, false);
            }
            if (this.press > 0 && (this.cost <= 0 || this.golem == -1L)) {
                if (this.press >= 90) {
                    for (a = 0; a < 10; ++a) {
                        FXDispatcher.INSTANCE.drawVentParticles((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, this.field_145850_b.field_73012_v.nextGaussian() * 0.1, 0.0, this.field_145850_b.field_73012_v.nextGaussian() * 0.1, 0xAAAAAA);
                    }
                }
                this.press -= 3;
            }
        }
        if (complete) {
            this.cost = 0;
            this.golem = -1L;
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    public boolean[] checkCraft(long id) {
        IGolemProperties props = GolemProperties.fromLong(id);
        ItemStack[] cc = props.generateComponents();
        boolean[] ret = new boolean[cc.length];
        int a = 0;
        for (ItemStack stack : props.generateComponents()) {
            ret[a] = this.checkAdjacentChests(stack);
            ++a;
        }
        return ret;
    }

    public boolean startCraft(long id, EntityPlayer p) {
        ItemStack placer = new ItemStack(ItemsTC.golemPlacer);
        placer.func_77983_a("props", (NBTBase)new NBTTagLong(id));
        if (this.func_70301_a(0) == null || this.func_70301_a(0).func_190926_b() || this.func_70301_a(0).func_190916_E() < this.func_70301_a(0).func_77976_d() && this.func_70301_a(0).func_77969_a(placer) && ItemStack.func_77970_a((ItemStack)this.func_70301_a(0), (ItemStack)placer)) {
            this.golem = id;
            this.props = GolemProperties.fromLong(this.golem);
            for (ItemStack stack : this.components = this.props.generateComponents()) {
                if (this.checkAdjacentChests(stack) || InventoryUtils.isPlayerCarryingAmount(p, stack, true)) continue;
                this.cost = 0;
                this.props = null;
                this.components = null;
                this.golem = -1L;
                return false;
            }
            this.cost = this.props.getTraits().size() * 2;
            for (ItemStack stack : this.components) {
                this.cost += stack.func_190916_E();
                if (this.consumeFromAdjacentChests(stack)) continue;
                InventoryUtils.consumePlayerItem(p, stack, true, true);
            }
            this.maxCost = this.cost;
            this.func_70296_d();
            this.syncTile(false);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.wand, SoundCategory.BLOCKS, 0.25f, 1.0f);
            return true;
        }
        this.cost = 0;
        this.props = null;
        this.components = null;
        this.golem = -1L;
        return false;
    }

    @Override
    public boolean func_94041_b(int par1, ItemStack stack2) {
        return stack2 != null && !stack2.func_190926_b() && stack2.func_77973_b() instanceof ItemGolemPlacer;
    }

    boolean drawEssentia() {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            TileEntity te = ThaumcraftApiHelper.getConnectableTile(this.field_145850_b, this.func_174877_v(), face);
            if (te == null) continue;
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(face.func_176734_d())) {
                return false;
            }
            if (ic.getSuctionAmount(face.func_176734_d()) >= this.getSuctionAmount(face) || ic.takeEssentia(Aspect.MECHANISM, 1, face.func_176734_d()) != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnectable(EnumFacing face) {
        return face.func_176736_b() >= 0 || face == EnumFacing.DOWN;
    }

    @Override
    public boolean canInputFrom(EnumFacing face) {
        return this.isConnectable(face);
    }

    @Override
    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    @Override
    public void setSuction(Aspect aspect, int amount) {
    }

    @Override
    public int getMinimumSuction() {
        return 0;
    }

    @Override
    public Aspect getSuctionType(EnumFacing face) {
        return Aspect.MECHANISM;
    }

    @Override
    public int getSuctionAmount(EnumFacing face) {
        return this.cost > 0 && this.golem >= 0L ? 128 : 0;
    }

    @Override
    public Aspect getEssentiaType(EnumFacing loc) {
        return null;
    }

    @Override
    public int getEssentiaAmount(EnumFacing loc) {
        return 0;
    }

    @Override
    public int takeEssentia(Aspect aspect, int amount, EnumFacing facing) {
        return 0;
    }

    @Override
    public int addEssentia(Aspect aspect, int amount, EnumFacing facing) {
        if (!this.bufferedEssentia && this.cost > 0 && this.golem >= 0L && aspect == Aspect.MECHANISM) {
            this.bufferedEssentia = true;
            return 1;
        }
        return 0;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean checkAdjacentChests(ItemStack itemStack) {
        int c = itemStack.func_190916_E();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (face == EnumFacing.UP || (c -= ThaumcraftInvHelper.countTotalItemsIn(this.func_145831_w(), this.func_174877_v().func_177972_a(face), face.func_176734_d(), itemStack, ThaumcraftInvHelper.InvFilter.BASEORE)) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean consumeFromAdjacentChests(ItemStack itemStack) {
        int c = itemStack.func_190916_E();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (face == EnumFacing.UP || itemStack.func_190926_b()) continue;
            itemStack = InventoryUtils.removeStackFrom(this.func_145831_w(), this.func_174877_v().func_177972_a(face), face.func_176734_d(), itemStack, ThaumcraftInvHelper.InvFilter.BASEORE, false);
        }
        return itemStack.func_190926_b();
    }
}

