/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.devices;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import thaumcraft.api.crafting.IStabilizable;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.tiles.TileThaumcraft;

public class TileStabilizer
extends TileThaumcraft
implements ITickable,
IEnergyStorage {
    private int ticks = 0;
    private int delay = 0;
    private final int chargeCost = 100;
    protected int energy;
    protected final int capacity = 1000;
    protected final int maxReceive = 1000;

    public void func_73660_a() {
        if (BlockStateUtils.isEnabled(this.func_145832_p()) && !this.field_145850_b.field_72995_K) {
            ++this.ticks;
            if (this.delay <= 0 && this.ticks % 5 == 0 && this.energy >= 100) {
                this.tryAddStability();
            }
            if (this.delay > 0) {
                --this.delay;
            }
        }
    }

    private void tryAddStability() {
        int m = this.energy / 100;
        boolean flag = false;
        int d = 0;
        EnumFacing facing = BlockStateUtils.getFacing(this.func_145832_p());
        List targets = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - (facing.func_82601_c() < 0 ? 8 : 0)), (double)(this.field_174879_c.func_177956_o() - (facing.func_96559_d() < 0 ? 8 : 0)), (double)(this.field_174879_c.func_177952_p() - (facing.func_82599_e() < 0 ? 8 : 0)), (double)(this.field_174879_c.func_177958_n() + 1 + (facing.func_82601_c() > 0 ? 8 : 0)), (double)(this.field_174879_c.func_177956_o() + 1 + (facing.func_96559_d() > 0 ? 8 : 0)), (double)(this.field_174879_c.func_177952_p() + 1 + (facing.func_82599_e() > 0 ? 8 : 0))));
        if (targets.size() > 0) {
            for (Entity e : targets) {
                if (e.field_70128_L || !(e instanceof IStabilizable)) continue;
                if (((IStabilizable)e).getStability() == IStabilizable.EnumStability.VERY_STABLE) break;
                ((IStabilizable)e).addStability(m);
                flag = true;
                d = (int)Math.sqrt(e.func_174818_b(this.func_174877_v()));
                break;
            }
        }
        if (!flag) {
            BlockPos p = this.func_174877_v().func_177972_a(facing);
            for (int a = 0; a < 8; ++a) {
                TileEntity t = this.field_145850_b.func_175625_s(p);
                if (t != null && t instanceof IStabilizable) {
                    if (((IStabilizable)t).getStability() == IStabilizable.EnumStability.VERY_STABLE) break;
                    ((IStabilizable)t).addStability(m);
                    flag = true;
                    d = a + 1;
                    break;
                }
                p = p.func_177972_a(facing);
            }
        }
        if (flag) {
            this.energy -= 100 * m;
            this.func_70296_d();
            this.syncTile(false);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), m, d - 1);
        } else {
            this.delay = 20;
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i != 0) {
            if (this.field_145850_b.field_72995_K) {
                EnumFacing facing = BlockStateUtils.getFacing(this.func_145832_p());
                for (int a = 0; a < i; ++a) {
                    double x = (double)((float)this.func_174877_v().func_177958_n() - (float)facing.func_82601_c() / 1.6f + 0.5f) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                    double y = (double)((float)this.func_174877_v().func_177956_o() - (float)facing.func_96559_d() / 1.6f + 0.5f) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                    double z = (double)((float)this.func_174877_v().func_177952_p() - (float)facing.func_82599_e() / 1.6f + 0.5f) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                    FXDispatcher.INSTANCE.drawCurlyWisp(x + (double)((float)facing.func_82601_c() / 2.0f), y + (double)((float)facing.func_96559_d() / 2.0f), z + (double)((float)facing.func_82599_e() / 2.0f), (double)((float)facing.func_82601_c() / 25.0f * (float)j) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0033f, (double)((float)facing.func_96559_d() / 25.0f * (float)j) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0033f, (double)((float)facing.func_82599_e() / 25.0f * (float)j) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0033f, 0.5f, 0.75f, 0.5f, 1.0f, 0.5f, null, 1, 0, a % 3 * 2);
                    x = (double)((float)this.func_174877_v().func_177958_n() - (float)facing.func_82601_c() / 1.6f + 0.5f) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                    y = (double)((float)this.func_174877_v().func_177956_o() - (float)facing.func_96559_d() / 1.6f + 0.5f) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                    z = (double)((float)this.func_174877_v().func_177952_p() - (float)facing.func_82599_e() / 1.6f + 0.5f) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                    FXDispatcher.INSTANCE.drawCurlyWisp(x, y, z, (double)((float)facing.func_82601_c() / 25.0f * (float)j) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.002f, (double)((float)facing.func_96559_d() / 25.0f * (float)j) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.002f, (double)((float)facing.func_82599_e() / 25.0f * (float)j) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.002f, 0.25f, this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat(), 0.5f, null, 1, 0, 1 + a % 3 * 2);
                }
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }

    @Override
    public void readSyncNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("energy");
    }

    @Override
    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("energy", this.energy);
        return nbt;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        EnumFacing face = BlockStateUtils.getFacing(this.func_145832_p());
        return face != facing && capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        EnumFacing face = BlockStateUtils.getFacing(this.func_145832_p());
        if (face != facing && capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        ((Object)((Object)this)).getClass();
        int energyReceived = Math.min(1000 - this.energy, Math.min(1000, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return 1000;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

